#include "mbed.h"
#include "nRF24L01P.h"
#include "LCD_DISCO_L476VG.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PE_15, PE_14, PE_13, PE_12, PE_10, PE_11);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
LCD_DISCO_L476VG lcd;


void channelChangeMode (void)
{
    char stayInWhile = 1; 
    char receivedChannelCharacter;
    int rf_channel = 2400;
    pc.printf("Channel menu\n\r");
    pc.printf("select channel\n\r");
    while(stayInWhile) {
        pc.printf("waiting for Channel\n\r");
        if ( pc.readable() ) {

            receivedChannelCharacter = pc.getc();

            if (receivedChannelCharacter >= '1' && receivedChannelCharacter <= '9') { // if received 0 through 9 load transmit buffer
                pc.printf("received valid number\n\r");
                receivedChannelCharacter = receivedChannelCharacter - 0x30;
                rf_channel = rf_channel + receivedChannelCharacter;
                pc.printf("new channel, %d\n\r", rf_channel);
                my_nrf24l01p.setRfFrequency(rf_channel);
                wait(1);
                pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
                stayInWhile = 0;
            } else {
                pc.printf(" invalid number\n\r");
            }
        }
        wait(1);
    }
    pc.printf("exiting  Channel change mode\n\r");

}
void OutputpowerchangeMode (void)
{

    char stayInWhile = 1;
    char receivedOutputPowerCharacter;
    int rf_OutputPower = 0;
    pc.printf("OutputPower menu\n\r");
    pc.printf("select OutputPower\n\r");
    while(stayInWhile) {
        pc.printf("waiting for OutputPower\n\r");
        if ( pc.readable() ) 
        {
            receivedOutputPowerCharacter = pc.getc();

            if (receivedOutputPowerCharacter == '0')
            {
                my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_ZERO_DB );
                pc.printf("set max output\n\r");
            
            }
            else if (receivedOutputPowerCharacter == '1')
            {
                my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_6_DB );
            
            }
            else if (receivedOutputPowerCharacter == '2')
            {
                my_nrf24l01p.setRfOutputPower (NRF24L01P_TX_PWR_MINUS_12_DB);
            }
            else if (receivedOutputPowerCharacter == '3')
            {
                my_nrf24l01p.setRfOutputPower (NRF24L01P_TX_PWR_MINUS_18_DB);
            }              
            // add other power settings
            else 
            {
                pc.printf(" invalid number\n\r");
            }
        }
        wait(1);
    }
    pc.printf("exiting  OutputPower change mode\n\r");

}

void AirDataRate (void)
{

    char stayInWhile = 1;
    char receivedDataRateCharacter;
    int rf_DataRate = 0;
    pc.printf("DataRate menu\n\r");
    pc.printf("select DataRate\n\r");
    while(stayInWhile) 
    {
        pc.printf("waiting for DataRate\n\r");
        if ( pc.readable() ) 
        {
           receivedDataRateCharacter = pc.getc();

          if (receivedDataRateCharacter == '1') 
            { 
           my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
             // if received 0 through 9 load transmit buffer
            }
               else if (receivedDataRateCharacter == '2')
                {
                  my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);
                }  
               else if  (receivedDataRateCharacter == '3')
                {
                   my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_2_MBPS);
                }    
                
                
                
                pc.printf("received valid number\n\r");
                receivedDataRateCharacter = receivedDataRateCharacter - NRF24L01P_DATARATE_1_MBPS;
                rf_DataRate = rf_DataRate + receivedDataRateCharacter;
                pc.printf("new DataRate, %d\n\r", rf_DataRate);
                my_nrf24l01p.getAirDataRate();
                wait(1);
                pc.printf( "nRF24L01+ DataRate    : %d MHz\r\n",  my_nrf24l01p.getAirDataRate() );
                stayInWhile = 0;
            }
        }
    
}

int main()
{

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   4

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
    char receivedTerminalCharacter;

    uint32_t temp = 0;
    uint8_t stemp[7] = {0};
    //uint8_t title[] = "      DISCOVERY STM32L476";
    my_nrf24l01p.powerUp();


    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    printf("Hello\n");
    //led_green = 1;
    lcd.Clear();
    lcd.DisplayString((uint8_t *)"HELLO");
    wait(5);
    lcd.Clear();

    while (1) 
    {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) {
            receivedTerminalCharacter = pc.getc();

            if (receivedTerminalCharacter >= '0' && receivedTerminalCharacter <= '9') {
                // if received 0 through 9 load transmit buffer
                pc.printf("Loading TX buffer");
                // ...add it to the transmit buffer
                txData[txDataCnt++] = pc.getc();

                // If the transmit buffer is full
                if ( txDataCnt >= sizeof( txData ) ) {
                    // Send the transmitbuffer via the nRF24L01+
                    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

                    txDataCnt = 0;

                    // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
                    myled1 = !myled1;
                }
            }

            else if (receivedTerminalCharacter == 'h') {
                pc.printf("Radio help menu\n\r");
                pc.printf("Press c for channel: \n\r");
                pc.printf("Press t for TX Power: \n\r");
                pc.printf("Press d for datarate: \n\r");
            } else if (receivedTerminalCharacter == 'c') {
                channelChangeMode();

            } else if (receivedTerminalCharacter == 't') {
                OutputpowerchangeMode();

            } else if (receivedTerminalCharacter == 'd') {

                AirDataRate();
            }

        }

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                pc.putc( rxData[i] );
            }
            lcd.Clear();
            lcd.DisplayString((uint8_t *)"REC");
            wait(5);
            lcd.Clear();
        }

        // printf("Scroll sequence\n");
        //led_green = 0;
        //lcd.Clear();

        // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
        myled2 = !myled2;
    }
}
