#ifndef MAIN_H
#define MAIN_H

#define pressureWait 100
#define airflowWait 100

#include "mbed.h"
#include "keller_pressure.h"
#include "sensirion_sf04.h"
#include "PID.h"
#include "coil-driver.h"
//#include "VL6180.h"

// Mbed application shield display
#include "C12832A1Z.h"
#include "Small_7.h"
#include "Fonts/ArialR12x14.h"

Coil shutoff(PE_5, 5000, 40, 6); // Shutoff valve, 5ms spike time, 25kHz PWM at 15% duty cycle
Coil injector(PF_8, 200, 40, 3); // Injector valve, 200us spike time, 25kHz PWM at 7.5% duty cycle

C12832A1Z lcd(D11, D13, D12, D7, D10); // MOSI, SCK, Reset, A0, CS
// LCD width and height (minus 1)
#define lcdWidth 127
#define lcdHeight 31

// ISO/SEV pressure: 10psi, DES: 25-30psi
float pumpSetPointPSI=0;
#define pumpMinPSI 0
#define pumpMaxPSI 85
//#define pumpHystPSI 2

// Gas flow sensor defines
#define SFM7033_ADDR 0x40
// End gas flow sensor defines

// Liquid pump defines
// PID settings
#define pumpPIDRate pressureWait/1000.0 // Pump PID computation interval (seconds)
float pumpKp = 2.0;
float pumpKi = 1.0;
#define pumpKd 0

#define pumpPwmFrequency 1000 // Frequency of PWM signal supplied to pump
#define pumpTachPoles 6 // 6 pulses per revolution
#define pumpTachPin PE_7 // Pump tach input (green wire)
#define pumpCtrlPin PE_10 // Pump control (white wire)
// End Liquid pump defines

Thread print_process_values_t, update_pressures_t, update_airflow_t, update_level_t, update_lcd_t, update_shutoff_t;
Mutex i2c1_m, i2c2_m, stdio_m;

//DigitalOut myled(LED2);
Serial pc(USBTX, USBRX, 115200); // tx, rx, baud

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl, int freq) : I2C(sda, scl) {
        frequency(freq);
    };
};

//I2CPreInit gI2C1(I2C_SDA, I2C_SCL, I2C frequency);
I2CPreInit i2c1(PB_9, PB_8, 100000);
I2CPreInit i2c2(PB_11, PB_10, 100000);

KELLER_PRESSURE pumpPressure(i2c1, 0x40);
KELLER_PRESSURE mixerPressure(i2c1, 0x41);



// Sensirion gas flow sensor object (i2c object, i2c address, calibration field, resolution 9-16 bit)
// calibration field 1: Air, 2: O2, 3: N2O
SF04 sfm7033(i2c2, SFM7033_ADDR, 1, 14); // Gas flow sensor (SFM7033)

// Mbed application shield
AnalogIn pot1(A0);
AnalogIn pot2(A1);

PwmOut pump(pumpCtrlPin);
//pump.period(.001);

PID pump_control_PID(pumpKp, pumpKi, pumpKd, pumpPIDRate);

int pumpTachCounts = 0;
float pumpRpm = 0;
InterruptIn pumpTach(pumpTachPin);

PwmOut ledRed(PE_11);
PwmOut ledGrn(PD_15);
DigitalOut ledBlu(PF_12);

// Level sensor
//VL6180 level(i2c1); //I2C object
//float agentlevel = 0;

//Timer t; // Runtime timer
//float runtime;

bool completed = false;
#endif