#include "main.h"

void pump_tach_trigger()
{
    //pumpTachCounts++;
    ledRed = !ledRed;
}

void pump_tach_update()
{
    float i = pumpTachCounts; // In case it triggers mid-calculation
    pumpTachCounts = 0;
    pumpRpm = (i/pumpTachPoles)*60;
}

void pump_init()
{
    pump.period(.001); // 1kHz PWM
    pump = 0;
    ledGrn.period(.001);

    //InterruptIn pumpTach(pumpTachPin);
    //pumpTach.rise(&pumpTachTrigger);

    pump_control_PID.setInputLimits(pumpMinPSI, pumpMaxPSI);
    pump_control_PID.setOutputLimits(0.0, 1.0); // Output is a PWM signal ranging from 0-1
    pump_control_PID.setMode(AUTO_MODE);
    pump_control_PID.setSetPoint(pumpSetPointPSI); // pump setpoint based on pot 2*/
}

void pump_pid_update(char error)
{
    if (pumpPressure.status != 0x40) {
        pump = 0;
        pump_control_PID.reset();
    } else {
        
        pumpSetPointPSI = floor(((double)pot2)/5*pumpMaxPSI)*5; // Update pump pressure setpoint based on value of pot2 and round down
        
        pump_control_PID.setSetPoint(pumpSetPointPSI);

        //Update the process variable.
        pump_control_PID.setProcessValue(pumpPressure.pressurePSI-mixerPressure.pressurePSI);
        //PID calculation and set the new output value.
        pump = pump_control_PID.compute();
        //pump = 0.1;
        ledGrn = ((float)1.0-pump.read());
    }
}

void update_pressures()
{
    Timer timer;
    timer.start();
    char error;
    while (true) {
        i2c1_m.lock();
        timer.reset();
        error = pumpPressure.readPT();
        error |= mixerPressure.readPT();
        int wait = (pressureWait - timer.read_ms());
        i2c1_m.unlock();
        Thread::wait(wait);
        pump_pid_update(error);
    }
}

void update_airflow()
{
    Timer timer;
    timer.start();
    char error;
    while (true) {
        i2c2_m.lock();
        timer.reset();
        error = sfm7033.Measure(FLOW);
        int wait = (airflowWait - timer.read_ms());
        i2c2_m.unlock();
        Thread::wait(wait);
    }
}

//void update_level()
//{
//    Timer timer;
//    timer.start();
//    while (true) {
//        i2c1_m.lock();
//        timer.reset();
//        agentlevel = (float)level;
//        int wait = (1000 - timer.read_ms());
//        i2c1_m.unlock();
//        Thread::wait(wait);
//    }
//}

//float get_level()
//{
//    i2c1_m.lock();
//    float value = (float)level;
//    i2c1_m.unlock();
//    return value;
//}



void print_process_values()
{
    Thread::wait(100); // Wait initially to allow sensors to update, prevents a zero reading from going to serial
    Timer timer;
    timer.start();
    while (completed == false) {
        stdio_m.lock();
        timer.reset();
        Thread::wait(10);
        //float runtime = timer.read_ms();
        pc.printf("%05.2fpsi %04.01fC %04.01fF %05.2fpsi %04.01fC %04.01fF %05.1f%% %04.0fRPM %05.0f %s %04.1f %05.2fpsi %05.2fpsi %05.2fpsi\r\n",
                  pumpPressure.pressurePSI, pumpPressure.temperatureC, pumpPressure.temperatureF,
                  mixerPressure.pressurePSI, mixerPressure.temperatureC, mixerPressure.temperatureF,
                  pump.read()*100, pumpRpm,
                  (((float)sfm7033.flow.i16 / 2) / sfm7033.scaleFactor.u16), sfm7033.flowUnitStr,
                  (double)pot1*18, pumpPressure.pressurePSI-mixerPressure.pressurePSI, pumpSetPointPSI, ((double)pot2)*pumpMaxPSI);
        int wait = (200 - timer.read_ms());

        stdio_m.unlock();
        Thread::wait(wait);
    }
}

void update_lcd()
{
    Timer timer;
    timer.start();
    while (true) {
        float flow = ((((float)sfm7033.flow.i16 / 2) / sfm7033.scaleFactor.u16) < 0 ? 0 : (((float)sfm7033.flow.i16 / 2) / sfm7033.scaleFactor.u16));
        flow = flow/1000;
        stdio_m.lock();
        timer.reset();
        lcd.cls();
        lcd.font((unsigned char*)ArialR12x14);
        lcd.locate(0, 0);
        lcd.printf("%.2f slpm AA: %.1f", flow, (double)pot1*18);
        lcd.locate(0, 14);
        lcd.printf("PV: %.1f", (pumpPressure.pressurePSI-mixerPressure.pressurePSI));
        lcd.locate(64, 14);
        lcd.printf("SV: %.1f", pumpSetPointPSI);
        int wait = (1000 - timer.read_ms());
        stdio_m.unlock();
        Thread::wait(wait);
    }
}

void update_shutoff()
{
    Timer timer;
    timer.start();
    while (true) {
        float threshold = 0.1;
        timer.reset();
        if((double)pot1 < 0.05) {
            shutoff.off();
            //pc.printf("shutoff off\r\n");
            //Thread::wait(1000);
        }
        if((double)pot1 >= 0.1) {
            shutoff.on();
            //pc.printf("shutoff on\r\n");
            //Thread::wait(1000);
        }
        int wait = (200 - timer.read_ms());
        Thread::wait(wait);
    }
}



// main() runs in its own thread in the OS
int main()
{
    //t.start(); // Start runtime timer
    pump_init();
    ledBlu = 1;
    pc.printf("Serenity Starting up...\n\r");
    //pumpTach.rise(&pump_tach_trigger);
    
    /*pc.printf("Pmin: %.03f Pmax: %.03f\r\n", pumpPressure.pmin, pumpPressure.pmax);
    pc.printf("Year: %d Month: %d Day: %d Mode: %d\r\n", pumpPressure.year, pumpPressure.month, pumpPressure.day, pumpPressure.mode);
    pc.printf("Status: 0x%x\r\n", pumpPressure.getStatus());*/


    // Thread to turn shutoff valve on/off
    update_shutoff_t.set_priority(osPriorityHigh);
    update_shutoff_t.start(update_shutoff);

    // Thread to poll pressure sensors
    update_pressures_t.set_priority(osPriorityNormal);
    update_pressures_t.start(update_pressures);

    // Thread to poll airflow sensor
    update_airflow_t.set_priority(osPriorityNormal);
    update_airflow_t.start(update_airflow);

    // Thread to poll level sensor
    //update_level_t.set_priority(osPriorityIdle);
    //update_level_t.start(update_level);

    // Thread to update lcd
    update_lcd_t.set_priority(osPriorityIdle);
    update_lcd_t.start(update_lcd);

    // Thread to send process values to serial port
    print_process_values_t.set_priority(osPriorityLow);
    print_process_values_t.start(&print_process_values);

    while (true) {
        //pc.printf("%d ms have passed\r\n", t.read_us()/1000);
        //pc.printf("%.02fkPa %.02fpsi %.02fC %.02fF\r\n", pumpPressure.pressureKPA, pumpPressure.pressurePSI, pumpPressure.temperatureC, pumpPressure.temperatureF);
        if((double)pot1 >= 0.1) {
            injector.on();
        }
        //pc.printf("shutoff on\r\n");
        Thread::wait(3);

        injector.off();
        //pc.printf("shutoff off\r\n");*/
        Thread::wait(497);
    }
}

