#ifndef COIL_DRIVER_H
#define COIL_DRIVER_H

#include "mbed.h"

// Coil driver class. Applies full power for given "spike" time
// and then applies a PWM signal to keep the coil energized at a lower power.
class Coil
{
public:
    Coil(PinName _controlPin, uint16_t _spikeus, uint16_t _holdperiod_us, uint16_t _holdpulse_us);

    //InterruptIn controlIn; // Input for external coil "ON" signal
    PwmOut controlOut; // PWM output pin driving coil
    uint16_t spikeus, holdperiod_us, holdpulse_us, pwmFrequency;
    
    char status(); // Return 1 if coil is energized, 0 if not
    void on();
    void off();
};

#endif