// Begin sample code
/*
#include "mbed.h"
#include "coil-driver.h"

// Coil parameters [control pin, spike time (us), hold time period (us), hold time pulse width (us)]
Coil yellow(A0, 200, 40, 3); // Injector

Coil orange(A1, 5000, 40, 10); // Shutoff valve
DigitalOut fb(A2); // Fast shutoff circuit for injection valve. High when valve is off, low when valve is on.

int main()
{
    while (true) {
        orange.on();
        fb = 0;
        yellow.on();
        Thread::wait(1000);
        orange.off();
        yellow.off();
        fb = 1;
        Thread::wait(1000);
    }
}
*/
// End sample code

#include "coil-driver.h"

// Default constructor
Coil::Coil(PinName _controlPin, uint16_t _spikeus, uint16_t _holdperiod_us, uint16_t _holdpulse_us)
    :   controlOut(_controlPin),
        spikeus(_spikeus),
        holdperiod_us(_holdperiod_us),
        holdpulse_us(_holdpulse_us)
{
    controlOut.write(0.0); // Ensure coil output is off by default
    controlOut.period_us(holdperiod_us); // PWM control period (uint16_t microseconds)

};

char Coil::status()
{
    char status;
    if(controlOut.read() == 0) {
        status = 0;
    } else {
        status = 1;
    }
    return status;
}

void Coil::on()
{
    if(controlOut.read() == 0.0) {
        controlOut.write(1.0);
        wait_us(spikeus);
        controlOut.pulsewidth_us(holdpulse_us);
    }
}

void Coil::off()
{
    controlOut.write(0.0);
}