///-----------------------------------------------------------------
///   Description:      BQ76PL536A Driver
///   Author:           David Wahl
///   Date:             13-JUL-2021
///   Notes:            Initial release
///
///   Revision History:
///   Name:           Date:        Description:
///-----------------------------------------------------------------

#include "mbed.h"
#include "bq76pl536a.h"

// a SPI sub-class that provides a constructed default
/*class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName sclk, int freq, int bits, int mode) : SPI(mosi, miso, sclk)
    {
        frequency(freq);
        format(bits, mode);
    };
};*/

//SPIPreInit spi(PA_7, PA_6, A1, 500000, 8, 1);
SPI spi(PA_7, PA_6, A1);

u8t attachedCells[] = {5};
u8t numDev = sizeof(attachedCells)/sizeof(attachedCells[0]);
u8t numCells = 0;

// (SPI object, PinName cs, u8t numDev, u8t attachedCells[], u16t cov[mV], u16t cuv[mV], u8t balanceTimeout[sec], bool balanceEnabled)
BQ76PL536A bq_pack(spi, PB_0, numDev, 4000, 3000, 5, true);

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut cs(D3); // Chip select for BQ76PL536A

int main()
{
    //wait(1);
    //spi.format(8,1);
    //spi.frequency(50000);


    for (int i = 0; i<numDev; i++) {
        numCells +=attachedCells[i];
    }

    float cellVolts[5];

    pc.baud(115200);
    pc.printf("Starting up...\r\n");

    //wait_us(6);
    bq_pack.readAll(1);
    bq_pack.write(1,ADC_CONTROL_REG,bq_pack.bqPackData[ADC_CONTROL_REG]|5);

    //pc.printf("Status: %u\r\n",bq_pack.devStatus());
    //pc.printf("COV: %u CUV: %u, numDev: %d numCells: %d\r\n", bq_pack.cov, bq_pack.cuv, bq_pack.numDev, numCells);
    //pc.printf("%u %u %u %u %u\r\n", bq_pack.attachedCells[0], bq_pack.attachedCells[1], bq_pack.attachedCells[2], bq_pack.attachedCells[3], bq_pack.attachedCells[4]);
    //pc.printf("%u %u %u %u\r\n", bq_pack.cellVolts[0], bq_pack.cellVolts[1], bq_pack.cellVolts[2], bq_pack.cellVolts[3]);

    while(1) {
        wait(1);
        bq_pack.adcConvert();

        wait_us(500);
        bq_pack.readAll(1);

        /*for (int i = 0; i <5; i++) {
            cellVolts[i] = bq_pack.cellVolts(bq_pack.bqPackData[VCELL1_L_REG+(i<<1)],bq_pack.bqPackData[VCELL1_L_REG+(i<<1)|1]);
        }

        for (int i = 0; i <5; i++) {
            pc.printf("%.3f",cellVolts[i]);
            if (i!=4) {
                pc.printf(" ,");
            } else {
                pc.printf("\r\n");
            }
        }*/



        pc.printf(" %.3f",bq_pack.cellVolts(bq_pack.bqPackData[VCELL1_L_REG],bq_pack.bqPackData[VCELL1_L_REG+1]));
        pc.printf(" %.3f",bq_pack.cellVolts(bq_pack.bqPackData[VCELL2_L_REG],bq_pack.bqPackData[VCELL2_L_REG+1]));
        pc.printf(" %.3f",bq_pack.cellVolts(bq_pack.bqPackData[VCELL3_L_REG],bq_pack.bqPackData[VCELL3_L_REG+1]));
        pc.printf(" %.3f",bq_pack.cellVolts(bq_pack.bqPackData[VCELL4_L_REG],bq_pack.bqPackData[VCELL4_L_REG+1]));
        pc.printf(" %.3f\r\n",bq_pack.cellVolts(bq_pack.bqPackData[VCELL5_L_REG],bq_pack.bqPackData[VCELL5_L_REG+1]));
        //u8t addr_ctrl = bq_pack.readRegister(1, ADDRESS_CONTROL_REG);

    }
}
