///-----------------------------------------------------------------
///   Description:      Read from Keller-Druck I2C pressure sensor
///   Author:           David Wahl
///   Date:             5-APR-2018
///   Notes:            Added readP function
///
///   Revision History:
///   Name:         Date:           Description:
///                 6-MAY-2019      Added check on startup to detect whether or not a sensor is plugged in (initFailed bool)
///-----------------------------------------------------------------


#ifndef KELLER_PRESSURE_H
#define KELLER_PRESSURE_H

#include "mbed.h"

#define I2C_READ 1
#define I2C_WRITE 0

#define KELLER_PRESSURE_I2C_CLK_SPD 400000L
#define KELLER_PRESSURE_REQUEST_MEASUREMENT 0xAC
#define KELLER_PRESSURE_MEASUREMENT_DONE 0x40

#define KELLER_PRESSURE_CUST_ID0 0x00 // for DB access
#define KELLER_PRESSURE_CUST_ID1 0x01 // for DB access
#define KELLER_PRESSURE_SCALING0 0x12 // Year [0..31]+2010 Bit11..15 | Month [0..15] Bit7..10| Day [0..31] Bit2..6| P-Mode[0..3] Bit0..1 (Y:5bit|M:4bit|D:5bit|P:2bit)
#define KELLER_PRESSURE_SCALING1 0x13 // Pmin [bar] MSWord (Pmin [bar] als 32bit float)
#define KELLER_PRESSURE_SCALING2 0x14 // Pmin [bar] LSWord (Pmin [bar] als 32bit float)
#define KELLER_PRESSURE_SCALING3 0x15 // Pmax [bar] MSWord (Pmax [bar] als 32bit float)
#define KELLER_PRESSURE_SCALING4 0x16 // Pmax [bar] LSWord (Pmax [bar] als 32bit float)

#define KELLER_PRESSURE_SCALING0_YEAR_MASK 0xF800
#define KELLER_PRESSURE_SCALING0_MONTH_MASK 0x0780
#define KELLER_PRESSURE_SCALING0_DAY_MASK 0x007C
#define KELLER_PRESSURE_SCALING0_MODE_MASK 0x0003

class KELLER_PRESSURE
{
protected:
    I2C &i2c;
    uint8_t mi2cAddress;

    char _write(char regAddress, char data);
    char _read_multibyte(char regAddress, char* data, char count);


public:
    KELLER_PRESSURE(I2C &i2c, int addr);
    ~KELLER_PRESSURE();
    char getStatus();
    bool initFailed;
    uint16_t Cust_ID0, Cust_ID1, Scaling0, Scaling1, Scaling2, Scaling3, Scaling4;

// Date of manufacture info
    uint16_t year;
    uint8_t month, day, mode;

    uint16_t status, pressure, temperature; // raw readings
    float pmin, pmax; // Min, max pressures (bar) read from device

    // Pressures are absolute
    double pressureBAR, pressurePSI, pressureKPA, temperatureC, temperatureF;

    char readPT(); // return 0 if good reading, 1 if error
    char readP(); // return 0 if good reading, 1 if error
    bool isAvailable();
    char readUserInfo();
};

#endif