///-----------------------------------------------------------------
///   Description:      BQ76PL536A Driver
///   Author:           David Wahl
///   Date:             13-JUL-2021
///   Notes:            Initial release
///
///   Revision History:
///   Name:           Date:        Description:
///-----------------------------------------------------------------

#ifndef BQ76PL536A_H
#define BQ76PL536A_H

#include "mbed.h"
#include "bq76pl536a_typedefs.h"

class BQ76PL536A
{
protected:
    SPI spi;
    DigitalOut cs;



    void setAddresses();
    void softReset();

    u8t pec(u8t crcBuffer[], u8t crcLength);

public:
    // (SPI object, PinName cs, u8t attachedCells[], u16t cov[mV], u16t cuv[mV], u8t balanceTimeout[sec], bool balanceEnabled)
    BQ76PL536A(SPI _spi, PinName _cs, u8t _numDev,  u16t _cov, u16t _cuv, u8t _balanceTimeout, bool balanceEnabled);
    //BQ76PL536A(SPI _spi, PinName _cs);

    BQ76PL536A();

    bool read(u8t deviceAddress, u8t regAddress, u8t count, u8t *pRegisterValue);
    void write(u8t deviceAddress, u8t regAddress, u8t regData);

    void adcConvert();
    bool readAll(u8t deviceAddress);

    u8t error, balanceTimeout;
    u16t cov, cuv;
    bool balanceEnabled;
    u8t numDev, attachedCells[];

    u8t bqPackData[65];

    float cellVolts(u8t lobyte, u8t hibyte);
};

#endif