
#include "mbed.h"
#include "mtsas.h"

//Phone number to send to and receive from. Must be in the form "1xxxxxxxxxx"
string PHONE_NUMBER = "CHANGE ME PLEASE";

DigitalOut heater(A1);
AnalogIn sensor(A0);
DigitalIn button(D5);

int main(void)
{       
    printf("Breathalizer Starting ...\n\r");    
    
    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
    MTSLog::setLogLevel(MTSLog::INFO_LEVEL);

    Cellular::Sms txtmsg;
    txtmsg.phoneNumber = PHONE_NUMBER;
    
    if(PHONE_NUMBER == "CHANGE ME PLEASE") {
       while(1) {
           printf("FORGOT TO SET THE PHONE NUMBER\r\n");
           wait(1.0f);
        }       
     }
     
    /** STMicro Nucelo F401RE
    * The supported jumper configurations of the MTSAS do not line up with
    * the pin mapping of the Nucleo F401RE. Therefore, the MTSAS serial TX
    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
    * Serial1 TX (Shield pin D8).
    * Uncomment the following line to use the STMicro Nuceleo F401RE
    */
    MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);

    //Sets the baud rate for communicating with the radio
    io->baud(115200); 
    
    //Creates a radio object
    Cellular* radio = CellularFactory::create(io);
    
    if (! radio) {
        logFatal("Failed to initialize radio");
        return 1;
    }
    
    float value = 0.0f;
    heater = 0;  //Active Low, 0 is turning it on.
    wait(0.1f);

    // Waiting for the sensor to warm-up
    while(value > 0.001f) {
        wait(1.0f);
        value = 1.0f - sensor;
        printf("Sensor is warming up : %2.2f\r\n", value);
    }

    printf("Sensor is warmed up!!! :-) \r\n");

    while(1) {
        while(!button) {
            //Do Nothing
        }
        printf("3\r\n");
        wait(1.0f);
        printf("2\r\n");
        wait(1.0f);
        printf("1\r\n");
        wait(1.0f);
        printf("BLOW!!!!  :-)");
        wait(3.0f);
        value = 1.0f - sensor;

        if (value > .8f) {
            txtmsg.message = "Get Uber Now! ;-)";
        } else if (value > .6f) {
            txtmsg.message = "Feeling Groovey";
        } else if (value > .4f) {
            txtmsg.message = "Have Another";
        } else {
            txtmsg.message = "Boooring";
        }
        printf("%s\n\r", txtmsg.message.c_str());
        printf("Sensor is: %2.2f\r\n", value);

        
        // Send SMS message to phone
        for (int i = 1; i < 10; i++) {
            if(radio->sendSMS(txtmsg) == MTS_SUCCESS) {
                logInfo("Sent SMS successfully: <%s>\n", txtmsg.message.c_str());
                break;
            } else {
                logError("Failed to send SMS: <%s>\n", txtmsg.message.c_str());
            }
        }
    }
}