/*
 * Simple TcpServer using the UIPEthernet library for ENC28J60 Ethernet boards.
 *
 */

#include "mbed.h"
#include "UIPEthernet.h"
#include "UIPServer.h"
#include "UIPClient.h"

Serial  pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
UIPEthernetClass    UIPEthernet(p11, p12, p13, p8);         // mosi, miso, sck, cs
#elif defined(TARGET_NUCLEO_F103RB) || defined(TARGET_NUCLEO_L152RE) || defined(TARGET_NUCLEO_F030R8)  \
   || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F302R8) || defined(TARGET_NUCLEO_L053R8)  \
   || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_F072RB)  \
   || defined(TARGET_NUCLEO_F091RC) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F070RB)  \
   || defined(TARGET_KL25Z ) || defined(TARGET_KL46Z) || defined(TARGET_K64F) || defined(TARGET_KL05Z) \
   || defined(TARGET_K20D50M) || defined(TARGET_K22F) \
   || defined(TARGET_NRF51822) \
   || defined(TARGET_RZ_A1H)
UIPEthernetClass    UIPEthernet(D11, D12, D13, D10);        // mosi, miso, sck, cs
#endif

// MAC number must be unique within the connected network. Modify as appropriate.
const uint8_t   MY_MAC[6] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 };
const uint16_t  MY_PORT = 10001;
EthernetServer  server = EthernetServer(MY_PORT);

int main(void)
{
//#define DHCP    1   // if you'd like to use static IP address comment out this line 
#if defined(DHCP)
    pc.printf("Searching for DHCP server..\r\n");
    if(UIPEthernet.begin(MY_MAC) != 1) {
        pc.printf("No DHCP server found.\r\n");
        pc.printf("Exiting application.\r\n");
        return 0;
    }
    pc.printf("DHCP server found.\r\n");
#else
    // IP address must be unique and compatible with your network.
    const IPAddress MY_IP(192, 168, 0, 205);    //  Change as appropriate.
    UIPEthernet.begin(MY_MAC, MY_IP);
#endif
    IPAddress   localIP = UIPEthernet.localIP();
    pc.printf("Local IP = ");
    for(uint8_t i = 0; i < 3; i++)
        pc.printf("%d.", localIP[i]);
    pc.printf("%d\r\n", localIP[3]);
    server.begin();

    while(1) {
        size_t size;

        if (EthernetClient client = server.available()) {
            pc.printf("Client connected.\r\n");
            pc.printf("Data received from client:\r\n");
            while((size = client.available()) > 0) {
                uint8_t* msg = (uint8_t*)malloc(size);
                size = client.read(msg, size);
                for(int i = 0; i < size; i++)
                    pc.printf("0x%x ", msg[i]);
                pc.printf("\r\n");
                free(msg);
                char* acknowledge = "Data received OK";
                client.write((uint8_t*)acknowledge, strlen(acknowledge));
                pc.printf(acknowledge);
            }
            client.stop();
            pc.printf("Client disconnected.\r\n");
        }
    }
}