#include "mbed.h"
Timer timer;
Serial uart(SERIAL_TX, SERIAL_RX);
 
DigitalOut COIL0(PA_5);
DigitalOut COIL1(PA_7);
DigitalOut COIL2(PA_6);
DigitalOut COIL3(PA_9);

uint8_t input_val;
volatile int32_t del_val = 2200;//us

void uart_callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    input_val = uart.getc();
    
    if (input_val == 'w')
    {   
    //increase time
        del_val -= 500;
        del_val = del_val < 2200 ? 2200 : del_val;  
    }
    
    else if (input_val == 's')
    {
        del_val += 500;
        del_val = del_val > 8000 ? 8000 : del_val;
    }   
    
    uart.printf("\r\nDelay between coil toggling is: %d microseconds", del_val);

}

void delay()
{
    timer.start();//start timer
    while (timer.read_us() < del_val);//and polling it to del_val time
    timer.stop();
    timer.reset();
}

void rotate()
{
    COIL0 = 1;
    delay();
    COIL0 = 0;

    COIL1 = 1;
    delay();
    COIL1 = 0;
        
    COIL2 = 1;
    delay();
    COIL2 = 0;
        
    COIL3 = 1;
    delay();
    COIL3 = 0;
        
}

int main()
{
    uart.baud(9600);
    uart.printf("\r\nStarted!");
    uart.attach(&uart_callback, Serial::RxIrq);//rx interrupt subscription
    while(1)
    {
        rotate();
    }
}
 