/* Chase pattern using a rotating phasor
 * Dan Minear
 * 2010-11-20
*/

#include "mbed.h"
#include "math.h"

Serial pc(USBTX, USBRX); // tx, rx
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

float brightness = 0.0;
float factor = 0.01;

int main() {
    pc.printf("\nPress 'u' or 'd'\n");
    char c;
    float angle = 0;
    float factor = 0.01;
    
    while(1) {
        if (pc.readable()) {
            c = pc.getc();
            if (c == 'u') { factor += 0.01; }
            if (c =='d') { factor -= 0.01; }
        }
        angle += factor;
        if (angle > 2 * 3.14159 ) { angle = 0; }
        
        led1 = (sin(angle) / 2)/2;
        led2 = (sin(angle + 3.1416 / 4))/2;
        led3 = (sin(angle + 3.1416 / 2))/2;
        led4 = (sin(angle + 3.1416 * 3 / 4))/2;
        
        wait(0.01);
    }
}



