#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "sprinkler_handler.h"
#include "share.h"
#include "NTPClient.h"

NTPClient ntp;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut ledgreen(p29);
DigitalOut ledyellow(p30);

LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;
Timer activity_timer;

DigitalIn bypass(p16);
DigitalIn zone1in(p17);
DigitalIn zone2in(p18);
DigitalIn zone3in(p19);
DigitalIn zone4in(p20);

DigitalOut zone1out(p24);
DigitalOut zone2out(p23);
DigitalOut zone3out(p22);
DigitalOut zone4out(p21);

int compute1out = 0;
int compute2out = 0;
int compute3out = 0;
int compute4out = 0;

void lanActivity( void ) {
    activity_timer.start();
    ledgreen = 0;
}

int main() {
    //Base::add_rpc_class<DigitalOut>();
    ledyellow = 0;
    ledgreen = 0;
    activity_timer.reset();

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
       printf("Error %d in setup.\n", ethErr);
       return -1;
    } else {
       ledgreen = 1;
    }

  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/check");
  // the main url with be http://a.b.c.d/sprinkler
  // a GET request will return current status
  // a POST with parameters of zone<n> and duration in seconds will set it
  svr.addHandler<SprinklerHandler>("/sprinkler");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");

  Timer tm;
  int timesync = 0;
  tm.start();
  time_t initialtime = time(NULL);
  printf("Time as a basic string = %s\r", ctime(&initialtime));
  //Listen indefinitely
  while(true) {
   //wait(0.01);
    Net::poll();
    if(tm.read()>0.5) {
      ledyellow = !ledyellow; //Show that we are alive
      tm.start();
      timesync++;
    }
    if(activity_timer > 0.2) {
        ledgreen = 1;
    }
    
    if (timesync > 3600 * 2) {  // every hour
            printf( "Setting time...\r\n" );
            Host server2(IpAddr(), 123, "pool.ntp.org");
            ntp.setTime(server2);
            time_t seconds = time(NULL);
            printf("Time as a basic string = %s\r", ctime(&seconds));
            timesync = 0;
    }    
    
    if (bypass) { // ignore all other choices other than inputs
        led1 = zone1out = zone1in;
        led2 = zone2out = zone2in;
        led3 =  zone3out = zone3in;
        led4 = zone4out = zone4in;
    } else {    // take computed outputs
        led1 = zone1out = compute1out;
        led2 = zone2out = compute2out;
        led3 = zone3out = compute3out;
        led4 = zone4out = compute4out;
    }
  }
}

