#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "derby_handler.h"
#include "Servo.h"
#include "share.h"

//I2C i2c(p28,p27); //p9, p10);        // sda, scl

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut ledgreen(p30);
DigitalOut ledyellow(p29);

LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;
InterruptIn button1(p11);
InterruptIn button2(p12);
InterruptIn button3(p13);
InterruptIn button4(p14);
Timer timer;
Servo myservo(p26);
DigitalOut startsol(p25);
DigitalOut lane1led(p21);
DigitalOut lane2led(p22);
DigitalOut lane3led(p23);
DigitalOut lane4led(p24);

int blinkm=0;
float lane1;
float lane2;
float lane3;
float lane4;
int lane1enable = 0;
int lane2enable = 0;
int lane3enable = 0;
int lane4enable = 0;

void reset_lane_latch_enables() {
    lane1enable = 1;
    lane2enable = 1;
    lane3enable = 1;
    lane4enable = 1;
}
    
void lane1trig () {
    if (lane1enable == 1) {
        lane1enable = 0;
        lane1 = timer.read();
        lane1led = 0;
    }
}
    
void lane2trig () {
    if (lane2enable == 1) {
        lane2enable = 0;
        lane2 = timer.read();
        lane2led = 0;
    }
}

void lane3trig () {
    if (lane3enable == 1) {
        lane3enable = 0;
        lane3 = timer.read();
        lane3led = 0;
    }
}

void lane4trig () {
    if (lane4enable == 1) {
        lane4enable = 0;
        lane4 = timer.read();
        lane4led = 0;
    }
}


int main() {
  //Base::add_rpc_class<DigitalOut>();
  button1.rise( &lane1trig );
  button2.rise( &lane2trig );
  button3.rise( &lane3trig );
  button4.rise( &lane4trig );
  ledyellow = 0;
  ledgreen = 0;
  myservo.calibrate(0.0006,45);
  timer.reset();
  myservo = 0.7;
  startsol = 0;
    lane1led = 0;
    lane2led = 0;
    lane3led = 0;
    lane4led = 0;


  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  } else {
    ledgreen = 1;
  }

  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/simple");
  svr.addHandler<SimpleHandler3>("/simple3");
  //svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");
  if (blinkm) {BlinkInit();}
  
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true) {
    Net::poll();
    if(tm.read()>0.5) {
      ledyellow = !ledyellow; //Show that we are alive
      //FadeToRandomColor();
      tm.start();
      //printf ("timer is %f\n\r", timer.read() );
    }
    
    led1 = ! button1;
    led2 = ! button2;
    led3 = ! button3;
    led4 = ! button4;
    
  }
  
  return 0;

}

