/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "derby_handler.h"
#include "Servo.h"
#include "share.h"

#include <string>
#include <cstring>


//#define __DEBUG
#include "dbg/dbg.h"

void reset_lane_latch_enables(void);

Timeout gatetimer;
Timeout soltimer;
Timeout gameover;

SimpleHandler3::SimpleHandler3(const char* rootPath, 
                                const char* path, 
                                TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath,
                                                                        path,
                                                                        pTCPSocket)
{

}

SimpleHandler3::~SimpleHandler3()
{
  DBG("\r\nHandler destroyed\r\n");
}

void SimpleHandler3::doGet()
{
  char resp[300];
 
  DBG("\r\nIn SimpleHandler::doGet()\r\n");  
  string str = "GET path is " + path();
  sprintf( resp, "%s\nlane1:%f\nlane2:%f\nlane3:%f\nlane4:%f\n", str.c_str(), lane1, lane2, lane3, lane4 );
  
  setContentLen( strlen(resp) );
  
  respHeaders()["Connection"] = "close";
  respHeaders()["Content-type"] = "text/plain";
  writeData(resp, strlen(resp));
  DBG("\r\nExit SimpleHandler::doGet()\r\n");
}

void SimpleHandler3::doPost()
{
 string str = "POST path is " + path();
 
 // find out if it's a reset or start
 const char * match = strstr( path().c_str(), "reset");
 if  (match > 0) {         // must be reset
    // handle reset
    timer.reset();
    myservo = 0.7;
    energizeSol();
    gatetimer.detach();
    soltimer.detach();
    gameover.detach();
    raiseGate();
    deenergizeSol();
    turnoffleds();
    ledcheck();

    DBG("\r\nreset called\r\n");
  }
 match = strstr( path().c_str(), "start");
 if  (match > 0) {         // must be start
    gatetimer.detach();
    soltimer.detach();
    gameover.detach();
    raiseGate();
    deenergizeSol();
    if (blinkm) {
        FadeToColor(255,0,0);
        wait(1.0);
        FadeToColor(255,255,0);
        wait(1.0);
        FastColorChg(0,255,0);
    }
    lane1led = 1;
    lane2led = 1;
    lane3led = 1;
    lane4led = 1;
    reset_lane_latch_enables();
    wait(0.1);
    timer.reset();
    timer.start();
    lane1 = 10.0;
    lane2 = 10.0;
    lane3 = 10.0;
    lane4 = 10.0;
    myservo = 0.2;      // drop the gate
    startsol = 0;
    gatetimer.attach( this, &SimpleHandler3::raiseGate, 2.0 );
    soltimer.attach( this, &SimpleHandler3::energizeSol, 10.0 );
    gameover.attach( this, &SimpleHandler3::turnoffleds, 10.0 );
    
    DBG("\r\nstart called\r\n");
  }
  
  const char * resp = str.c_str(); 
  setContentLen( strlen(resp) );
  respHeaders()["Content-type"] = "text/plain";
  respHeaders()["Connection"] = "close";
  writeData(resp, strlen(resp));
  DBG("\r\nExit SimpleHandler::doGet()\r\n");
}

void SimpleHandler3::doHead()
{

}

  
void SimpleHandler3::onReadable() //Data has been read
{

}

void SimpleHandler3::onWriteable() //Data has been written & buf is free
{
  DBG("\r\nSimpleHandler::onWriteable() event\r\n");
  close(); //Data written, we can close the connection
}

void SimpleHandler3::onClose() //Connection is closing
{
  //Nothing to do
}

void SimpleHandler3::raiseGate( void )
{
    myservo = 0.7;     // reset the gate
    DBG( "\r\nraiseGate\r\n");
}

void SimpleHandler3::deenergizeSol( void )
{
    startsol = 0;
    DBG( "\r\ndeenergizeSol\r\n");
}

void SimpleHandler3::energizeSol( void )
{
    startsol = 1;
}

void SimpleHandler3::turnoffleds( void )
{
    lane1led = 0;
    lane2led = 0;
    lane3led = 0;
    lane4led = 0;
    if (blinkm) {
        FadeToColor(0,0,0);
    }

    DBG( "\r\ndeenergizeSol\r\n");
}

void SimpleHandler3::ledcheck( void ) {
    lane1led = 1;
    wait(0.2);
    lane2led = 1;
    wait(0.2);
    lane3led = 1;
    wait(0.2);
    lane4led = 1;
    wait(0.2);
    lane1led = 0;
    wait(0.2);
    lane2led = 0;
    wait(0.2);
    lane3led = 0;
    wait(0.2);
    lane4led = 0;
    wait(0.2);
}    
