/*****************************************************
- Description: mbed to Dynamixel connection test using
    the library
- Requirements:
    Dynamixel (i.e. DX116, RX28)
    MAX3088/MAX485 (RS485 transceiver)
- Connections:
    MAX3088     --  mbed
    ======================
    Pin 1       --  Pin 14
    Pin 2       --  Pin 15
    Pin 4       --  Pin 13

- Comments:
    See schematic for wiring details and class
    documentation for available methods.
*****************************************************/
#include "mbed.h"
#include "Dynamixel.h"

DigitalOut debug1(LED1);
DigitalOut debug2(LED2);
DigitalOut debug3(LED3);
DigitalOut debug4(LED4);
int main()
{
    debug1 = 0;
    debug2 = 0;
    debug3 = 0;
    debug4 = 0;
    Dynamixel motor2(p13, p14, p15, 1, 57600); // TX, RX, TX_ENABLE, MOTOR_ID, BD

    /**************************
    *** Check communication ***
    **************************/
    motor2.toggleLED(1);
    wait(1);
    motor2.toggleLED(0);
    /**************************
    ***** Set max angles  *****
    **************************/
    motor2.setAngleLimit(0, ADDRESS_CW_ANGLE_LIMIT);
    wait(0.5);
    motor2.setAngleLimit(0, ADDRESS_CCW_ANGLE_LIMIT);
    wait(0.5);
    /**************************
    ******** Set speed ********
    **************************/
    motor2.setSpeed(50); // 0-1023 CW
    debug1 = 1;
    wait(2);
    motor2.setSpeed(2000); // 1024-2047 CCW
    wait(2);
    debug2 = 1;
    motor2.setSpeed(0);
}