/*****************************************************
- Description: mbed to Dynamixel connection test using
    the library
- Requirements: 
    Dynamixel (i.e. DX116, RX28)
    MAX3088/MAX485 (RS485 transceiver)
- Connections:
    MAX3088     --  mbed
    ======================
    Pin 1       --  Pin 14
    Pin 2       --  Pin 15
    Pin 4       --  Pin 13
    
- Comments:
    See schematic for wiring details and class 
    documentation for available methods.
*****************************************************/
#include "mbed.h"
#include "Dynamixel.h"

int main()
{
    Dynamixel DX116(p13, p14, p15, 9, 57600);
    
    DX116.toggleLED(1);
    wait(0.5);
    DX116.toggleLED(0);
    DX116.setSpeed(0);
    wait(0.5);
    DX116.move(0);          // MOVE
    wait(1);
    DX116.setSpeed(100);
    wait(0.5);
    DX116.move(1023);       // MOVE
    wait(1);
    DX116.setSpeed(1023);
    wait(1);
    DX116.move(0);          // MOVE
}   