#include "mbed.h"
#include "heapsize.hpp"

DigitalOut GreenLed(LED_GREEN);
DigitalOut RedLed(LED_RED);
DigitalOut BlueLed(LED_BLUE);

void BlinkErrorCodeNoRtos( int blinks)
{
    GreenLed = 1;
    BlueLed = 1;
    for( int i=0; i<blinks; i++) {
        RedLed = 0;
        wait( 0.15);
        RedLed = 1;
        wait( 0.15);
    }
    wait(0.5);
}

extern "C" void HardFault_Handler()
{
    while( 1)
        BlinkErrorCodeNoRtos(1);
}

extern "C" void UsageFault_Handler()
{
    while( 1)
        BlinkErrorCodeNoRtos( 2);
}

extern "C" void  BusFault_Handler()
{
    while( 1)
        BlinkErrorCodeNoRtos( 3);
}

extern "C" void MemManage_Handler()
{
    while( 1)
        BlinkErrorCodeNoRtos( 4);
}

/*
extern "C" void SVC_Handler(int R0)
{
    //wait(0.1);
}

extern "C" void NMI_Handler()
{
}

extern "C" void DebugMon_Handler()
{
    GreenLed = 1;

    BlueLed = 0;
    RedLed = 0;
    wait( 0.1);
    BlueLed = 1;
    RedLed = 1;
}

extern "C" void PendSV_Handler()
{
    BlueLed = 1;

    GreenLed = 0;
    RedLed = 0;
    wait( 0.1);
    GreenLed = 1;
    RedLed = 1;
}

extern "C" void SysTick_Handler()
{

}

extern "C" void IntDefaultHandler()
{
}
*/

int main()
{
#ifdef __CC_ARM
    printf( "CC ARM \r\n");
#elif defined(__GNUC__)
    printf( "GNUC \r\n");
#elif defined(__ICCARM__)
    printf( "ICC ARM \r\n");
#endif    
    
    printf( "in main, heap free is: %ld\r\n", heapSize());
    
    while (true) {        
        GreenLed = 0;
        BlueLed = 0;
        RedLed = 0;
        wait( 0.15);
        GreenLed = 1;
        BlueLed = 1;
        RedLed = 1;
        wait( 0.15);
    }
}