/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "port_api.h"

namespace mbed {

PinName parse_pins(const char *str) {

    static const PinName pin_digital[] = {D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15};
    static const PinName pin_analog[] = {A0, A1, A2, A3, A4, A5};
    
    if (str[0] == 'D') { // Dn
        uint32_t pin  = str[1] - '0'; // Dn
        uint32_t pin2 = str[2] - '0'; // Dnn
        if (pin2 <= 9) {
            pin = pin * 10 + pin2;
        }
        if (pin < 0 || pin > 15) {
            return NC;
        }
        return pin_digital[pin];
    } else if (str[0] == 'A') { // An
        uint32_t pin  = str[1] - '0'; // An
        uint32_t pin2 = str[2] - '0'; // Ann
        if (pin2 <= 9) {
            pin = pin * 10 + pin2;
        }
        if (pin < 0 || pin > 5) {
            return NC;
        }
        return pin_analog[pin];
    } else if (str[0] == 'L') {  // LEDn
        switch (str[3]) {
            case '1' : return LED1;
            case '2' : return LED2;
            case '3' : return LED3;
            case '4' : return LED4;
        }

    } else if (str[0] == 'U') {  // USB?X
        switch (str[3]) {
            case 'T' : return USBTX;
            case 'R' : return USBRX;
        }
    }

    return NC;
}

}
