#include "mbed.h"

class Speaker
{
public:
    Speaker(PinName pin) : _pin(pin) {
// _pin(pin) means pass pin to the Speaker Constructor
    }
// class method to play a note based on PwmOut class
    void PlayNote(float frequency, float duration, float volume) {
        _pin.period(1.0/frequency);
        _pin = volume/2.0;
        wait(duration);
        _pin = 0.0;
    }
private:
// sets up specified pin for PWM using PwmOut class 
    PwmOut _pin;
};

BusOut myled(LED1,LED2,LED3,LED4);
Serial blue(p28,p27);
Speaker mySpeaker(p21);

int main()
{
    mySpeaker.PlayNote(400.0,0.05,0.1);
    char bnum=0;
    char bhit=0;
    while(1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                mySpeaker.PlayNote(400.0,0.01,0.5);
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                mySpeaker.PlayNote(600.0,0.01,0.5);
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                mySpeaker.PlayNote(800.0,0.01,0.5);
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                mySpeaker.PlayNote(1000.0,0.01,0.5);
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}