/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/


/*
 * This is a simple example that uses the micro:bit radio to show if another
 * micro:bit is nearby broadcasting with the same group number.
 * The display will show the received signal strength in -dBm.
 *
 */

#include "config.h"
#include "MicroBit.h"

#if MICROBIT_BLE_ENABLED 
 #ifdef YOTTA_CFG
  #error "This example needs BLE to be disabled. Use the yotta config.json in the proximit-heart directory to do this"
 #else
  #error "This example needs BLE to be disabled in the microbit config file in the microbit-dal: MicroBitConfig.h"
 #endif
#endif

#ifdef USE_MICROBIT_ELEMENTS

// Used microbit components.

MicroBitDisplay display;
MicroBitRadio radio;
MicroBitMessageBus messageBus;

#else

// Complete microbit object.

MicroBit    uBit;

#endif
 
static int display = 0, receiving = 0, direction = 1;
static uint8_t radioRSSI = 98, radioGroup = radioGroupNumber;
ManagedString rxdata;
void onData(MicroBitEvent)
	{
    rxdata = uBit.radio.datagram.recv();
    receiving = 3;
    radioRSSI = uBit.radio.getRSSI();
    display = 1;
    }

void onButtonA(MicroBitEvent)
	{
	if ( radioGroup != radioGroupNumber )
		{
		radioGroup = radioGroupNumber;
    	uBit.radio.setGroup(radioGroup);
		}
	direction = -direction;
	display = 2;
	}

void onButtonAlong(MicroBitEvent)
	{
	display = 3;
	}

void onButtonAhold(MicroBitEvent)
	{
	display = 3;
	}

void onButtonAdouble(MicroBitEvent)
	{
	display = 3;
	}

void onButtonBlong(MicroBitEvent)
	{
	display = 4;
	}

void onButtonB(MicroBitEvent)
	{
	radioGroup += direction;
    uBit.radio.setGroup(radioGroup);
	display = 2;
	}

int main()
	{
	int sleeping;
	
    // Initialise the micro:bit runtime.
    uBit.init();
    uBit.radio.setGroup(radioGroupNumber);
    //Setup a handler to run when data is received.
    uBit.messageBus.listen(MICROBIT_ID_RADIO, MICROBIT_RADIO_EVT_DATAGRAM, onData);
    // Setup some button handlers to allow extra control with buttons.
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButtonA);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onButtonB);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_LONG_CLICK, onButtonAlong);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_LONG_CLICK, onButtonBlong);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_HOLD, onButtonAhold);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_DOUBLE_CLICK, onButtonAdouble);
	uBit.radio.enable();
 	
    while ( true )
    	{
		switch ( display )
			{
			default:
			case 0:	// nothing to display?
			uBit.display.print("?");
			sleeping = 1000;
			break;

			case 1:	// display signal strength.
    		uBit.display.scroll(radioRSSI);
			sleeping = 500;
			break;

			case 2:	// display group number.
    		uBit.display.print("#", 300);
   			uBit.display.scroll(radioGroup);
			sleeping = 500;
			break;

			case 3:	// display received data.
    		uBit.display.scroll(rxdata);
			sleeping = 500;
			break;
			}

		if ( receiving )
			{
			receiving -= 1;
			display = receiving && display == 1 ? 1 : 0;
			}
        uBit.sleep(sleeping);
 		}
}
