#ifndef PARSER_H
#define PARSER_H

#include "mbed.h"
//#include "rtos.h"
#include <cmath>
#include <vector>

using namespace std;

// class ParseResult {
//  public:
//   ParseResult(bool success) : success_(success) {};
//
//   void setRotateWith(float r, float v);
//   void setRotations(float r);
//
//   void setTunesData(const vector<float>& notes);
//   void setVelocity(float v);
//
//   float getRotations();
//   // float getRotationsWith();
//   float getVelocity();
//   const vector<float> getTunes();
//
//   int getMode();
//   bool isSuccessful();
//   void setState(bool state);
//
//  private:
//   bool success_;
//   float numRotations_;
//   float velocity_;
//   vector<float> tunes_;
//   int mode_;
// };
struct ParseResult {
  bool success;
  int mode;
  float velocity;
  float rotations;
  vector<float> tunes;
};

//method stubs for actions with parsed data
void fillRotateWith(ParseResult& result, float r, float v);
void fillRotate(float r);
void fillVelocity(float v);
void fillPlayTune(const vector<float>& notes);

//Helper, parses float & moves char ptr along
bool parseFloat(char * & term, float & result);

//Matches a note (eg C-D-E...) to the half-note position within an octave
int getNoteNo(const char * term);

//Converts the whole note with octave (eg C#5) to absolute frequency
bool noteToFreq(char * & term, float & result);

//Parses multiple notes and returns a float vector of ordered frequencies
bool parseNotes(char * term, vector<float> & notes);

//Parses one command ie. main of this 'module'
ParseResult parse(char * term);

#endif
