//#include "mbed.h"
//#include "rtos.h"
//#include <cmath>
//#include <vector>
#include "parser.h"

void fillRotateWith(ParseResult* result, float r, float v) {
    // ParseResult result;
    result->success = true;
    result->rotations = r;
    result->velocity = v;
    result->mode = 0;
    
    //PUT YOUR CUSTOM CODE HERE
    //pc.printf("Rotating : %f rotations w velocity %f ; ", r, v);
}

void fillRotate(ParseResult* result, float r) {
    result->success = true;
    result->rotations = r;
    result->mode = 1;
    //PUT YOUR CUSTOM CODE HERE
    //pc.printf("Rotating : %f rotations ; ", r);
}

void fillVelocity(ParseResult* result, float v) {
    result->success = true;
    result->velocity = v;
    result->mode = 2;
    //PUT YOUR CUSTOM CODE HERE
    //pc.printf("Rotating : %f velocity ; ", v);
    
}

void fillPlayTune(ParseResult* result,
              const vector<float>& notes) {
    result->success = true;
    result->tunes = notes;
    result->mode = 3;
    //PUT YOUR CUSTOM CODE HERE
    //pc.printf("playing tune");
}

bool parseFloat(char * & term, float & result) {
    float val;
    val = atof(term);
    while ((*term >= '0' && *term <= '9') || *term == '.' || *term == '-') term++;

    if (val > 999.99f || val < -999.99f) //from the specs of the excercise
        return false;

    result = val;
    return true;
}

int getNoteNo(const char * term) {
    switch (*term) {
        case 'C':
            return 0;
        case 'D':
            return 2;
        case 'E':
            return 4;
        case 'F':
            return 5;
        case 'G':
            return 7;
        case 'A':
            return 9;
        case 'B':
            return 11;
        default:
            return -1;
    }
}

bool noteToFreq(char * & term, float & result) {
    int noteNo, octave, pos;
    const float a4freq = 440.0;
    const int a4pos = 45;
    const float a = 1.059463094359295; //2 ^ (1/12)

    noteNo = getNoteNo(term);
    term++;

    if (noteNo < 0)
        return false;

    if (*(term) == '#')  {
        noteNo ++;
        term ++;
    } else if (*(term) == '^') {
        noteNo --;
        term ++;
    }

    //octave = atoi(term);
    octave = strtol(term, &term, 10);

    if (octave <= 0 || octave > 8)
        return false;

    pos = 12 * (octave - 1) + noteNo;
    result = a4freq * pow(a, pos - a4pos);
    
    return true;
}

bool parseNotes(char * term, vector<float> & notes) {
    while (*term != 0) {
        float note;
        if (noteToFreq(term, note)) {
            notes.push_back(note);
        } else {
            return false;
        }
    }

    return true; 
}

ParseResult parse(char * term) {
    float r, v;
    vector<float> notes;

    ParseResult result;
    result.success = false;
    if (*term == 'R') { //R or R-V commands
        term ++;
        if (!parseFloat(term, r)) 
            // return false;
            return result;
        
        if (*term == 0) {
            fillRotate(&result, r);
        } else if (*term == 'V') { //Parsing V part of R-V
            term ++;
            if (parseFloat(term, v))
                if (*term != 0) return result;
                if (v < 0) v *= -1;
                fillRotateWith(&result, r, v);
        } else
            return result;
    } else if (*term == 'V') { //V only commands
        term ++;
        if (parseFloat(term, v))
            if (*term != 0) return result;
            fillVelocity(&result, v);
    } else if (*term == 'T') { //T command
        term ++;
        if (parseNotes(term, notes))
            fillPlayTune(&result, notes);
        else
            return result;
    } else { //Unrecognized command
        return result;
    }

    return result;
}
