#ifndef MOTORCONTROL_H
#define MOTORCONTROL_H
 
#include "mbed.h"
 
#include "definitions.h"
//#include "photointerruptRoutines.h"

Thread motorController;

extern volatile float diskPosition;
int8_t upperState = 0;
int8_t lowerState = 0;
 
int8_t superState = 0;
int8_t superStateIndex = 0;
int8_t upperSwitchIndex = 0;
int8_t lowerSwitchIndex = 0;
 
volatile float duty = 0.0;
volatile int phaseLead = 120;
 
RawSerial pc(SERIAL_TX, SERIAL_RX);     //Initialise serial port

volatile float velocityPeriod = 0.004;     //0.4ms (velocityPwm) >> 40us (motorPwm)
volatile float velocityTon = 0.0;

volatile bool pwmOut = 1;
volatile int debugCounter = 0;
Ticker pwmPeriod;
Ticker pwmTon;

Ticker motorTicker;
float dtMotor = 0.1;

//inline void velocityPwmTon(){
//    pwmOut = 0;
//    pwmTon.detach();
//}
// 
//inline void velocityPwmPeriod(){
//    pwmOut = 1;
//    pwmTon.attach(&velocityPwmTon, velocityTon);
////    debugCounter++;
//}
// 
//void startVelocityPwm(float velocityPeriod){
//    pwmPeriod.attach(&velocityPwmPeriod, velocityPeriod);
//}

int8_t pinIndex(int8_t state) {
    int index = 0;
    while (index < 8) {
        if (state == 1) return index;
        index ++;
        state >>= 1;
    }
    return -1;
}
//Seting a given drive state (states 60 deg apart)
//Timer profiler;
//volatile float profilerDt = 0;

void motorOut(int8_t driveState, float duty, bool off = false){
    //Lookup the output byte from the drive state.
    int8_t driveOut = driveTable[driveState & 0x07];
 
    if (~driveOut & 0x01){              //Turn off first, to avoid short ccs in
        L1L.period_us(motorPWMPeriod);          //  transistors (eg L1L, L1H)
        L1L.write(0.0f);
    }
    if (~driveOut & 0x02){
        L1H.period_us(motorPWMPeriod);
        L1H.write(1.0f);
    }
    if (~driveOut & 0x04){
        L2L.period_us(motorPWMPeriod);
        L2L.write(0.0f);
    }
    if (~driveOut & 0x08){
        L2H.period_us(motorPWMPeriod);
        L2H.write(1.0f);
    }
    if (~driveOut & 0x10){
        L3L.period_us(motorPWMPeriod);
        L3L.write(0.0f);
    }
    if (~driveOut & 0x20){
        L3H.period_us(motorPWMPeriod);
        L3H.write(1.0f);
    }
        if (off) return;                    //Motors remain turned off
 
    if (driveOut & 0x01){               //Then turn on
        L1L.period_us(motorPWMPeriod);
        L1L.write(duty);
    }
    if (driveOut & 0x02){
        L1H.period_us(motorPWMPeriod);
        L1H.write(1.0f-duty);
    }
    if (driveOut & 0x04){
        L2L.period_us(motorPWMPeriod);
        L2L.write(duty);
    }
    if (driveOut & 0x08){
        L2H.period_us(motorPWMPeriod);
        L2H.write(1.0f-duty);
    }
    if (driveOut & 0x10){
        L3L.period_us(motorPWMPeriod);
        L3L.write(duty);
    }
    if (driveOut & 0x20){
        L3H.period_us(motorPWMPeriod);
        L3H.write(1.0f-duty);
    }
}

// Takes 133us
void precisionMotorOut(int angle, bool off = false){
//    profiler.reset();
//    profiler.start();
    angle %= 360;
    int8_t lowerStateIndex = (int8_t)(angle/60);
    upperState = driveTable[(lowerStateIndex + 1) % 6];
    lowerState = driveTable[lowerStateIndex];
   
    duty = ((float)(angle % 60)) / 60.0f;
    //assign duty to upperState
    //assign 1-duty to lowerState
   
    superState = upperState & lowerState;        //Only one bit high
    upperSwitchIndex = pinIndex(upperState - superState);      //1 bit is high
    lowerSwitchIndex = pinIndex(lowerState - superState);       //1 bits is high
    superStateIndex = pinIndex(superState);
 
    //Turn everything off first
    for (int j = 0; j <= 5; j++) {      
        if (j != superStateIndex) {
            LPins[j]->period_us(motorPWMPeriod);
            LPins[j]->write(PinOff[j]);
        }
    }
   
    if (off) return;                    //Motors remain turned off
   
   
    if (PinOff[superStateIndex] == 0.0f) {
        LPins[superStateIndex]->write(1.0f);
        LPins[upperSwitchIndex]->write(1-duty);    //1-d
        LPins[lowerSwitchIndex]->write(duty);
    } else {
        LPins[superStateIndex]->write(0.0f);
        LPins[upperSwitchIndex]->write(duty);
        LPins[lowerSwitchIndex]->write(1-duty);    //1-d
    }  
//    profiler.stop();
//    profilerDt = profiler.read_us();
}

inline void motorControl(){
    if(pwmOut == 1)                         //Only control
        precisionMotorOut(360-(((int)diskPosition+phaseLead)%360));
}

void motorHome() {                      //Basic synchronisation routine  
//    precisionMotorOut(0);                  //Put the motor in drive state 0 and
    motorOut(0, 1.0f);
    wait(3.0);                          // waits for it to stabilise
}
 
void stopInterrupts() {
    I1.rise(NULL);                      //turn off interrups       
    I1.fall(NULL);
    I2.rise(NULL);
    I2.fall(NULL);
    I3.rise(NULL);
    I3.fall(NULL);
}

void stopMotor(/*int finalPosition*/){                       //Stops the motor from turning   
    motorOut(4, 1.0f, true);
//    precisionMotorOut(finalPosition, true);
    wait(3);
}

void callMotorThread() {
    motorController.signal_set(0x1);   
} 

void driveMotor() {
    mutex.lock();
    state = updateState();
    mutex.unlock();
    motorOut((state-orState+lead+6)%6, velocityDuty);
}

void driveMotorThread() {
    while (true) {
        Thread::signal_wait(0x1);
        driveMotor();
    }
}
#endif