//#include "mbed.h"

#include "definitions.h"
#include "motorControl.h"
#include "photointerruptRoutines.h"
#include "commands.h"


//extern PinName I1Pin;
//DigitalOut myled(LED1);


int main() {
//    LPins[0] = &L1L;                        //Define the pins for the pin array
//    LPins[1] = &L1H;
//    LPins[2] = &L2L;
//    LPins[3] = &L2H;
//    LPins[4] = &L3L;
//    LPins[5] = &L3H;

    motorHome();
    dt_I3.start();
    
    CHA.rise(&CHA_rise);
    CHA.fall(&CHA_fall);
    CHB.rise(&CHB_rise);
    CHB.fall(&CHB_fall);
    motorController.start(callback(driveMotorThread));
    runCommand();
    while (true) {
        wait(1);
        //pc.printf("Speed: %f, duty cycle: %f, currentRevs: %i, vErr %f, prevErr; %f, dErr %f, totalVErr: %f \n\r",w3, velocityDuty, count_i3, VKp*vErr,VKp*vPrevErr, dErr, VKi*totalVErr);
        
        mutex.lock();
        float tmpW3 = w3;
        float tmpVelocityDuty = velocityDuty;
        float tmpCurrentRevs = currentRevs;
        float tmpCurrentError = currentError;
        float tmpDError = dError;
        mutex.unlock();
        
        pc.printf("speed: %f, duty: %f, currentRevs: %f, error: %f, dError %f \n\r", tmpW3, tmpVelocityDuty, tmpCurrentRevs, tmpCurrentError, tmpDError);

    }
    return 0;
}
