const float kp = 0.012f;
const float kd = 0.019f; //0.5f, 0.02
const float k = 10.0f;
const float dt = 0.002f;


volatile float currentRevs = 0.0;                 //number of revs done
volatile float goalRevs = 500;
volatile float prevError = 0.0;
volatile double dError = 0.0;
volatile float currentError = 0.0;
volatile float maximumV = 0.0;

Ticker controlTicker;

void control(){
    mutex.lock();
    if (w3 > maximumV) {
        lead = 2;
        return;
    }
    
    prevError = currentError;
    mutex.lock();
    currentRevs = diskPosition / 360 + count_i3;    // 1/360degr + 2pi*revs
    mutex.unlock();
    currentError = goalRevs - currentRevs;
    dError = (currentError - prevError)/dt;
    velocityDuty = k*(kp*currentError + kd*dError);
    if (velocityDuty > 0) lead = -2;
    else {
        lead = 2;
        velocityDuty = -velocityDuty;
    }
    if(velocityDuty > 1)
        velocityDuty = 1;
    mutex.unlock();
}

const float VKp = 0.054f;       //0.054
const float VKi = 0.0065f;    //0.0065
const float VKd = 0.0035f;    //0.0035

volatile float targetV = 35.0f;
volatile float totalVErr = 0.0f;
volatile float vPrevErr = 0.0f;
volatile float vErr = 0.0f;
volatile double dErr = 0.0f;

const float dtControl = 0.05f;

void controlVelocity(){
    if(w3 > 200)
        w3 = targetV;
    mutex.lock();
    vErr = targetV - w3;
    mutex.unlock();
    dErr = (vErr - vPrevErr)/dtControl;
    totalVErr += vErr*dtControl;
    velocityDuty = VKp*vErr + VKi*totalVErr + VKd*dErr;
    if(velocityDuty < 0){
        velocityDuty = -velocityDuty;
        lead = 2;
    }
    else
        lead = -2;
    vPrevErr = vErr;
}