#include <vector>

#include "mbed.h"
#include "controlLoops.h"
#include "parser.h"


volatile bool commandFinished = false;

void kickstartMotor() {
    state = updateState();
    motorOut((state-orState+lead+6)%6, 1.0f);
    wait(0.1);
}

void rotate(float r) {
    PRINT("Rotating for %.2f revolutions", r);
    goalRevs = r;
    kickstartMotor();
    startInterrupts();
    controlTicker.attach(&control, dt);
}

void setVelocity(float v) {
    targetV = v;
    PRINT("Spinning with V=%.2f rev/s", targetV);

    startInterrupts();
    controlTicker.attach(&controlVelocity, dtControl);
    kickstartMotor();
}

void rotateWith(float r, float v) {
    goalRevs = r;
    maximumV = v;
    PRINT("Rotating for %.2f revolutions with V=%.2f", goalRevs, maximumV);
    kickstartMotor();
    startInterrupts();
    controlTicker.attach(&control, dt);
}

void playTune(float freq) {
    motorPWMPeriod = (int)((1.0f/freq)*1000000);
    motorOut(0, 0.5);
    Thread::wait(1000);
}

void playTunes(const vector<float>& tunes) {
    PRINT("Playing music");
    for (int i=0; i<tunes.size(); ++i) {
        playTune(tunes[i]);
    }
    stopMotor();
}


void runCommand() {
    char buffer[256];
    PRINT("Ready for command");
    scanf("%s", buffer);
    ParseResult command = parse((char*) buffer);
    if (command.success) {
        switch(command.mode) {
            case 0: rotateWith(command.rotations, command.velocity); break;
            case 1: rotate(command.rotations); break;
            case 2: setVelocity(command.velocity); break;
            case 3: playTunes(command.tunes); break;
            default: return;
        }
    } else {
        PRINT("Invalid command");
    }
}