/*******************************************************************************/

#include "mbed.h"
#include "LCD_DISCO_F469NI.h"
#include "table.h"

/*******************************************************************************/

LCD_DISCO_F469NI lcd;
DigitalOut led1(LED1);

/*******************************************************************************/

volatile uint8_t mat_A, mat_B, mat_C, mat_D, mat_E, mat_F ;

uint8_t tb_fact1[4]; // circle prescale factors 4 circles top and 4 mirroring to bottom
uint8_t tb_fact2[4]; //

uint8_t multable[128][256]; // a prescale table

uint8_t wynik_X[8]; // X poss first 8 plots
uint8_t wynik_Y[8]; // Y poss first 8 plots

uint8_t plot_1X[128]; // first buffer 128 plot X values
uint8_t plot_1Y[128]; // first buffer 128 plot Y values
uint8_t plot_2X[128]; // 2nd buffer 128 plot X values
uint8_t plot_2Y[128]; // 2nd buffer 128 plot Y values

void calculate_matrix()
{
    volatile uint8_t t1, t2, t3, t4, t5, t6, t7, t8, t9, t10 ;
    static volatile uint16_t delta_x = 0x0100;
    static volatile uint16_t delta_y = 0xff00;
    static volatile uint16_t delta_z = 0xff00;
    
    static volatile uint16_t angle_x = 0x00;
    static volatile uint16_t angle_y = 0x00;
    static volatile uint16_t angle_z = 0x00;
    
    static volatile uint8_t sx;
    static volatile uint8_t sy; 
    static volatile uint8_t sz; 
    
    

     /*    update_angles   */
    angle_x = angle_x + delta_x;
    angle_y = angle_y + delta_y;    
    angle_z = angle_z + delta_z;
    
    sx = (uint8_t)  ((angle_x)>>8) & 0xFF;
    sy = (uint8_t)  ((angle_y)>>8) & 0xFF;
    sz = (uint8_t)  ((angle_z)>>8) & 0xFF;
    
    t1 = sy-sz;
    t2 = sy+sz;
    t3 = sx+sz;
    t4 = sx-sz;
    t5 = sx+sy+sz;
    t6 = sx-sy+sz;
    t7 = sx+sy-sz;
    t8 = sy+sz-sx;  
    t9  = sy-sx;
    t10 = sy+sx;




    mat_A = (uint8_t) ((sinus[64 + t1] + sinus[64 + t2]) >> 8) & 0xFF;
    mat_B = (uint8_t) ((sinus[t1] - sinus[t2]) >> 8) & 0xFF;
    mat_C = (uint8_t) ((sinus[128+sy] + sinus[128+sy]) >> 8) & 0xFF;
    mat_D = (uint8_t) ((sinus[t3] - sinus[t4] +  ((sinus[64+t6] - sinus[64+t5] + sinus[64+t8] - sinus[64+t7]) / 2)) >> 8) & 0xFF;
    mat_E = (uint8_t) ((sinus[64+t3] + sinus[64+t4] + ((sinus[t5] - sinus[t6] - sinus[t7] - sinus[t8]) / 2)) >> 8) & 0xFF;
    mat_F = (uint8_t) ((sinus[128 + t9] - sinus[128 + t10]) >> 8) & 0xFF;



}
//====================================================================================================
void insert_dots()
{
    volatile uint8_t i, i2, i3, dana, t9, t10, sx, sy, sz;
    volatile uint8_t t_x;
    volatile uint16_t wynik;

    
    t_x = 0x48;
    i2 = 0;
    for(i=3 ; i!=0xff ; i--)
    {
        t_x = t_x - 0x10;
        sx = t_x & 0x3F;
        sy = 0;
        sz = 0;
    
//;---------------------
//; F = invsin(t9)-invsin(t10)
//;---------------------
        t9  = sy-sx;
        t10 = sy+sx;
        mat_F = (uint8_t) ((sinus[128 + t9] - sinus[128 + t10]) >> 8) & 0xFF;

#ifdef debug_matrix
        printf("mat_F = 0x%X \n", mat_F);
#endif

        tb_fact1[i] = mat_F;
        tb_fact2[i2] = tb_fact1[i];
        i2++;
    };
    for(i=0 ; i<128 ; i++)
    {
        plot_1X[i];
        plot_1Y[i];
        plot_2X[i];
        plot_2Y[i]; 
    }
    dana = 0;
    for(i=0 ; i<128 ; i++)
    {
        wynik = 0;
        i3 = 0;
        for(i2=0 ; i2<128 ; i2++)
        {
            multable[i][i2] = (uint8_t) (((wynik) >> 8) & 0xFF);
            wynik = wynik + dana;
            i3--;
            multable[i][i3] = (uint8_t)  (0 - multable[i][i2]);
        }
        dana = dana +2;
    };
}
//===========================================================================
void calc_all_dots_01()
{
    volatile uint8_t row1, row2, i, i2, i3;
    volatile uint8_t add_x , add_y ;

    i2 = 0;
    for(i3 = 0; i3 < 4 ; i3++)  
    {
        row1 = tb_fact1[i3];
        
        add_x = multable[row1][mat_C];
        add_y = multable[row1][mat_F];
    
        row2 = tb_fact2[i3];
        
    
        for(i = 0; i < 8 ; i++)
        {
            plot_1X[i2]   = ((multable[row2][wynik_X[i]] + add_x) ^ 128);
            plot_1X[i2+1] = (plot_1X[i2] ^ 255);
            plot_1Y[i2]   = ((multable[row2][wynik_Y[i]] + add_y) ^ 128);
            plot_1Y[i2+1] = (plot_1Y[i2] ^ 255);
    
            plot_1X[i2+2] = ((multable[row2][wynik_X[i]] - add_x) ^ 128);
            plot_1X[i2+3] = (plot_1X[i2+2] ^ 255);
            plot_1Y[i2+2] = ((multable[row2][wynik_Y[i]] - add_y) ^ 128);
            plot_1Y[i2+3] = (plot_1Y[i2+2] ^ 255);
            
            i2 = i2 + 4;        
        }
    }
}
//================================================================================
void calc_all_dots_02()
{
    volatile uint8_t row1, row2, i, i2, i3;
    volatile uint8_t add_x , add_y ;
    
    i2 = 0;
    // 4 times calculate and mirroring circles = 4*16*2 = 128 vectordots
    for(i3 = 0; i3 < 4 ; i3++)  
    {
        row1 = tb_fact1[i3]; // prescale factor for X/Y offset data (add_x;add_y)
        
        add_x = multable[row1][mat_C]; // X offset  after prescale circle = possitoin X;Y 0;0
        add_y = multable[row1][mat_F]; // Y offset  after prescale circle
        
        row2 = tb_fact2[i3]; // prescale factor for actual circle
        
        // calculate 32 X;Y values of plots in mirroring 2nd circles
        for(i = 0; i < 8 ; i++)
        {
            plot_2X[i2]   = ((multable[row2][wynik_X[i]] + add_x) ^ 128);
            plot_2X[i2+1] = (plot_2X[i2] ^ 255);
            plot_2Y[i2]   = ((multable[row2][wynik_Y[i]] + add_y) ^ 128);
            plot_2Y[i2+1] = (plot_2Y[i2] ^ 255);
    
            plot_2X[i2+2] = ((multable[row2][wynik_X[i]] - add_x) ^ 128);
            plot_2X[i2+3] = (plot_2X[i2+2] ^ 255);
            plot_2Y[i2+2] = ((multable[row2][wynik_Y[i]] - add_y) ^ 128);
            plot_2Y[i2+3] = (plot_2Y[i2+2] ^ 255);
            
            i2 = i2 + 4;        
        }
    }
}
//==================================================================================
void calculate_8_dots()
{
    volatile uint8_t row1, row2;
    volatile uint8_t  v1, v2, v4, v5;
    volatile uint8_t i, i2;
    
    // calculate first 8 dots to following prescale and mirroring
    
    i2 = 0;
    for(i = 0 ; i < 4 ; i++)
    {
        
        row1 = tb_fact1[i];
        row2 = tb_fact2[i];
        
        v5 = multable[row1][mat_E];
        v2 = multable[row1][mat_B];
        v4 = multable[row2][mat_D];
        v1 = multable[row2][mat_A];
        
        wynik_X[i2]   = v1 + v2;
        wynik_Y[i2]   = v4 + v5;
        wynik_X[i2+1] = v1 - v2;
        wynik_Y[i2+1] = v4 - v5;    

    #ifdef debug_matrix
        printf("wynik_X[%d]  = 0x%X \n", i2   , wynik_X[i2]);
        printf("wynik_Y[%d]  = 0x%X \n", i2   , wynik_Y[i2]);
        printf("wynik_X[%d]  = 0x%X \n", i2+1 , wynik_X[i2+1]);
        printf("wynik_Y[%d]  = 0x%X \n", i2+1 , wynik_Y[i2+1]);     
    #endif
    
    #ifdef  show_first_pixels   
        putpixel(wynik_X[i2]   ^ 128 , wynik_Y[i2]   ^ 128 , WHITE);
        putpixel(wynik_X[i2+1] ^ 128 , wynik_Y[i2+1] ^ 128 , WHITE);            
    #endif  
/*
 $7A $15 ; $7A $E7 ; $68 $42 ; $66 $BA
 $46 $66 ; $42 $98 ; $19 $7A ; $15 $86
*/  
       i2 = i2 +2;
    
    }
}



int main()
{    
    led1 = 1;
     lcd.Clear(0);
     lcd.SetTextColor(LCD_COLOR_WHITE);
     int x, y, color, angle = 0;
     uint8_t i, wait=10;
     insert_dots();
    
  
   
  
    while(1)
    {
    
        calculate_matrix();
        calculate_8_dots();
        calc_all_dots_01(); // store plots values in first buffer
        
        
        // clear old plots
        for(i = 0; i < 128 ; i++)
            {
                lcd.DrawPixel(plot_2X[i] +272  , plot_2Y[i]+112 , 0);
            }
        // set the new plots
        for(i = 0; i < 128 ; i++)
            {
                 lcd.DrawPixel(plot_1X[i] +272  , plot_1Y[i]+112, LCD_COLOR_WHITE);
            }
    
        calculate_matrix();
        calculate_8_dots();
        calc_all_dots_02(); // store plots values in 2nd buffer
        wait_ms(10);
        
        // clear old plots
        for(i = 0; i < 128 ; i++)
            {
                lcd.DrawPixel(plot_1X[i]+272   , plot_1Y[i]+112 , 0);
            }
        // set the new plots    
        for(i = 0; i < 128 ; i++)
            {
                 lcd.DrawPixel(plot_2X[i]+272   , plot_2Y[i]+112 , LCD_COLOR_WHITE);
            }
   
          while (!(LTDC->CDSR & LTDC_CDSR_VSYNCS));


      
      led1 = !led1;
      wait_ms(25);
     
    }
}

