#include "ReadCommand.h"
#include "OfflineCommand.h"

ReadCommand::ReadCommand(Storage* storage, GonioService* gonioService)
{
    this->storage = storage;
    this->running = 0;
    this->addr = 0x00;
    this->gonioService = gonioService;
}

void ReadCommand::initialize()
{
    //setLed(1);
    //printf("ReadCommand\n");
    //__disable_irq();
    //readFromMemory();
    //__enable_irq();
}

void ReadCommand::finish()
{
    setLed(0);
}


void ReadCommand::execute()
{
    //Read has nothing to do with the IMU interrupt
}

void ReadCommand::button()
{
    printf("**** BUTTON: ReadCommand    *****\n");

    //__disable_irq();
    readFromMemory();
    //__enable_irq();
}


void ReadCommand::readFromMemory()
{
    uint8_t angle[2]= {0,0};
    int8_t imu[2]= {0,0};

    uint32_t addr = 0; 
    
    do{
        storage->read(addr);

        angle[0] = storage->readData();
        angle[1] = storage->readData();
        imu[0] = storage->readData();
        imu[1] = storage->readData();

        storage->endAction();
        
        /*
        printf("Memory: angle = %.2f, ", ((float)(angle[0] << 8) + angle[1]) * 0.087912087);
        printf("accelX = %.2f\n", ((float)(imu[0] << 8) + imu[1]) / 16.4);
        */
        
        gonioService->updateGonio( ((angle[0] << 8) + angle[1]) , ((imu[0] << 8) + imu[1]) ,1);
        wait(0.01);
        //printf("%d,%d\n", ((angle[0] << 8) + angle[1]), ((imu[0] << 8) + imu[1]));
        addr = addr + 4;
        
    } while(angle[0] != 255);
    
    //printf("DONE!\n");
}

