#ifndef _STORAGE_H_
#define _STORAGE_H_

#include "mbed.h"

class Storage
{

public:
    Storage();
    void setup();
    void setWREN();
    void setWRDI();
    
    int8_t getSR1();
    int8_t getSR2();
    
    void  clearSR();
    
    bool isBusy();
    void endAction();
    
    void pageProgram(int32_t addr);
    void writeData(int8_t data);
    
    void read(int32_t addr);
    int8_t readData();
    
    void bulkErase();
    void sectorErase(int32_t addr);
    void reset();

};

#endif /* _STORAGE_H_ */