#include "mbed.h"
#include <vector>
#include "commands.h"
#include "Sensors.h"
#include "Storage.h"

#include "BLEDevice.h"
#include "GonioService.h"


class Controller {
  
  std::vector<Command*> modeList;
  int currentModeSelector;
  bool buttonIntFlag;
  bool imuIntFlag;
  bool tickerIntFlag;
  bool tickerIntDataFlag;
  bool peak;
  
  int16_t angle;
  Sensors* sensors;
  Storage* storage;
  GonioService* gonioService;
  
  public:
  
  Controller();
  void disconnect();
  void setCommand(int);
  void buttonInt();
  void imuInt();  
  void tickerInt();    
  void tickerDataInt();

  Command* currentMode();
  void run();
};