#include "Storage.h"

SPI spi(p20, p22, p25); // mosi, miso, sclk
DigitalOut cs(p14); //Chip select

Storage::Storage()
{
    cs = 1;
    spi.format(8,3);
    spi.frequency(200000);
}

void Storage::setup()
{
}

void Storage::endAction()
{
    cs = 1;
}

void Storage::setWRDI()
{
    cs = 0;
    spi.write(0x04);
    cs = 1;
}

void Storage::setWREN()
{
    cs = 0;
    spi.write(0x06);
    cs = 1;
}

//for debug
int8_t Storage::getSR1()
{
    cs = 0;
    spi.write(0x05);
    int8_t status = spi.write(0x00);
    cs = 1;
    return status;
}

void Storage::clearSR(){
    cs = 0;
    spi.write(0x30);
    cs = 1;
    }

bool Storage::isBusy()
{
    cs = 0;
    spi.write(0x05);

    if(spi.write(0x00) & 0x1) {
        cs = 1;
        return true;
    } else {
        cs = 1;
        return false;
    }
}

void Storage::pageProgram(int32_t addr)
{
    setWREN();
    cs = 0;
    spi.write(0x12);

    char bytes[4];
    bytes[0] = (addr >> 24) & 0xff;
    bytes[1] = (addr >> 16) & 0xff;
    bytes[2] = (addr >> 8) & 0xff;
    bytes[3] = addr & 0xff;

    spi.write(bytes[0]);
    spi.write(bytes[1]);
    spi.write(bytes[2]);
    spi.write(bytes[3]);
    /*
    for(int i = 3; i >= 0; i--){
        spi.write((addr >> (8*i)) & 0xff);
    }
    */
}

void Storage::writeData(int8_t data)
{
    spi.write(data);
}

void Storage::read(int32_t addr)
{
    cs = 0;

    spi.write(0x13);

    char bytes[4];
    bytes[0] = (addr >> 24) & 0xff;
    bytes[1] = (addr >> 16) & 0xff;
    bytes[2] = (addr >> 8) & 0xff;
    bytes[3] = addr & 0xff;


    spi.write(bytes[0]);
    spi.write(bytes[1]);
    spi.write(bytes[2]);
    spi.write(bytes[3]);


    //for(int i = 3; i >= 0; i--){
    //  spi.write((addr >> (8*i)) & 0xff);
    //}
}

int8_t Storage::readData()
{
    return spi.write(0x00);
}

void Storage::bulkErase()
{
    cs = 0;
    spi.write(0x60);
     wait(0.001);
    cs = 1;
}

void Storage::reset()
{
    cs = 0;
    spi.write(0xF0);
    cs = 1;
}

void Storage::sectorErase(int32_t addr)
{
    setWREN();
    cs = 0;
    spi.write(0xDC);

    char bytes[4] = {0,0,0,0};
    bytes[0] = (addr >> 24) & 0xff;
    bytes[1] = (addr >> 16) & 0xff;
    bytes[2] = (addr >> 8) & 0xff;
    bytes[3] = addr & 0xff;

    spi.write(bytes[0]);
    spi.write(bytes[1]);
    spi.write(bytes[2]);
    spi.write(bytes[3]);
    
    cs = 1;
}
