#ifndef _SENSORS_H_
#define _SENSORS_H_

#include "mbed.h"

class Sensors
{
    char out[14];
    char cmd[3];

    int8_t imuData[12];
    uint8_t angle[2];
    int8_t angleDummy[2];
    
    int8_t sampleFrequencyIMU;

public:
    Sensors ();

    int8_t getAngleDummy(int);

    void    setupIMU(int8_t);
    void    setupAngle ();

    void    wakeIMU();
    void    disableIMU();

    //Update register values
    void    updateAngle();
    void   updateIMU();

    //Get must updated register values
    uint8_t  getAngle(int);
    int8_t   getIMU(int);
    int8_t getInterruptStatus();
    int8_t getMotionDetectionStatus();

    //Read and write register function for MPU
    int8_t readRegister(int8_t addr);
    void writeRegister(int8_t addr, int8_t value);

};

#endif /* _SENSORS_H_ */