#include "GonioService.h"

BLEDevice  _ble;
Gap::ConnectionParams_t fast;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    printf("\n\r disconnect %d:\n\r",reason);
    if(reason == Gap::LOCAL_HOST_TERMINATED_CONNECTION) {
        printf("\n\r local host terminated connection \n\r");
    }else{
    _ble.startAdvertising(); // restart advertising
    }
}

GonioService::GonioService():
    ble(_ble),
    G_ServiceUUID(0x9000),
    G_CharUUID(0x9001),
    G_ControlUUID(0x9002),
    gValueBytes(0,0,0),
    dataChar(G_CharUUID, gValueBytes.getPointer(),
             gValueBytes.getNumValueBytes(), GonioValueBytes::MAX_VALUE_BYTES,
             GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
    batteryChar(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, &batteryValue,
                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
    controlPoint(G_ControlUUID, &controlPointValue)
{
    setupService();
    //;
}

bool GonioService::isConnected()
{
    return ble.getGapState().connected;
}

uint8_t GonioService::getWriteValue()
{
    return writeValue;
}

void GonioService::disconnect(){
    ble.disconnect( Gap::LOCAL_HOST_TERMINATED_CONNECTION);
    }

bool GonioService::newValue()
{
    if(newValueFlag == 1) {
        newValueFlag = 0;
        return true;
    } else {
        return false;
    }
}

void GonioService::setupService()
{
    static bool serviceAdded = false; /* We should only ever need to add the heart rate service once. */
    if (serviceAdded) {
        return;
    }
    init();
    //batteryLevel(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, &batteryValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
    GattCharacteristic *charTable[] = {&dataChar, &controlPoint,&batteryChar};
    GattService         GonioService(G_ServiceUUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

    ble.addService(GonioService);
    serviceAdded = true;

    ble.onDataWritten(this, &GonioService::onDataWritten);
    setupAdvertising();
}

void GonioService::updateBattery(uint8_t newLevel)
{
    batteryValue = newLevel;
    ble.updateCharacteristicValue(batteryChar.getValueAttribute().getHandle(), &batteryValue, 1);
}

uint8_t GonioService::getBatteryLevel()
{
    return batteryValue;
}

void GonioService::updateGonio(uint16_t params, uint16_t acc, uint16_t gyro)
{
    gValueBytes.updateGonio(params,acc, gyro);
    ble.updateCharacteristicValue(dataChar.getValueAttribute().getHandle(), gValueBytes.getPointer(), gValueBytes.getNumValueBytes());
    //waitForEvent();
}

void GonioService::onDataWritten(const GattCharacteristicWriteCBParams *params)
{
    if (params->charHandle == controlPoint.getValueAttribute().getHandle()) {
        writeValue = params->data[0];
        newValueFlag = true;
    }
    //waitForEvent();    
}

void GonioService::waitForEvent(){
    ble.waitForEvent();
    }

uint8_t GonioService::getGServiceUUID()
{
    return G_ServiceUUID;
}

void GonioService::init()
{
    ble.init();
    ble.setTxPower(4);
    ble.onDisconnection(disconnectionCallback);
    ble.getPreferredConnectionParams(&fast);
    fast.minConnectionInterval = 6; // 7.5 ms (6*1.25)
    fast.maxConnectionInterval = 8; // 10 ms (8*1.25)
    fast.slaveLatency = 0;
    ble.setPreferredConnectionParams(&fast);
}

void GonioService::setupAdvertising()
{
    const static char DEVICE_NAME[] = "GonioMeter";
    static const uint16_t uuid16_list[] = {G_ServiceUUID};
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.setAdvertisingInterval(50);
    ble.startAdvertising();
}

