#include "mbed.h"
#include "Adafruit_SSD1306.h"
   
// W7500 onboard LED & Init
DigitalOut gled(LED2,0);

// I2C Class
I2C i2c(PA_10,PA_9);

// OLED Class   
Adafruit_SSD1306_I2c gOled(i2c,NC,0x78,64,128);

int main() {
      

    uint16_t cnt=0;
    uint16_t time =0, minute =58, second =0;
    
    gOled.begin();                
    gOled.printf("%ux%u \nHellow World\r\n", gOled.width(), gOled.height());
    gOled.display();
    gOled.setTextCursor(0,0);
    wait(1.0);    

    while(1)
    {
        gOled.setTextSize(2);
        gOled.clearDisplay();
        gOled.printf("%02d:%02d:%02d\n\n", time,minute,second);
        if(minute==59)
        {
            if(second == 59)
            {
                time++;
                minute = 0;
                second = 0;
            }
            else
            {                
                second++;
            }
        }
        else
        {
            if(second == 59)
            {                
                minute++;
                second = 0;
            }
            else
            {                
                second++;
            }
        }
        gOled.display();
        gOled.setTextCursor(0,0);        
        wait(1.0);
    }

}