#include "mbed.h"
#include "FATFileSystem.h"
#include "SDBlockDevice_GR_PEACH.h"
#include "USBHostMSD.h"

int main() {
    int i = 0;
    int storage_type = 0;
    char storage_str[16];

    FATFileSystem fs("storage");
    SDBlockDevice_GR_PEACH sd;
    USBHostMSD usb;

    while(1) {
        // try to connect a storage device
        while (1) {
            if (sd.connect()) {
                storage_type = 0; // SD
                strcpy(storage_str, "SD card");
                fs.mount(&sd);
                break;
            }
            if (usb.connect()) {
                storage_type = 1; // USB
                strcpy(storage_str, "USB memory");
                fs.mount(&usb);
                break;
            }
            Thread::wait(500);
        }

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        while(1) {
            // append a file
            FILE * fp = fopen("/storage/test1.txt", "a");

            if (fp != NULL) {
                fprintf(fp, "Hello %s World: %d!\r\n", storage_str, i++);
                printf("Goodbye World!\r\n");
                fclose(fp);
            } else {
                printf("FILE == NULL\r\n");
            }
            Thread::wait(500);

            // if device disconnected, try to connect again
            if (storage_type == 0) {
                if (!sd.connected())  break;
            } else {
                if (!usb.connected()) break;
            }
        }
        fs.unmount();
    }
}
