#include "mbed.h"

InterruptIn button(USER_BUTTON0);
DigitalOut led1(LED1);
Thread * pTestTask = NULL;

static void idle_hook(void) {
    // Do the following instead of "__WFI()"
    __SEV();
    __WFE();
    __WFE();
}

void SoftwareStandby(void) {
    volatile uint32_t dummy_32;
    volatile uint8_t dummy_8;

    core_util_critical_section_enter();

    // Set the standby_mode_en bit of the power control register in the PL310 to 1.
    L2C.REG15_POWER_CTRL = 0x00000001uL;
    dummy_32 = L2C.REG15_POWER_CTRL;

    // Clear the TME bit in the watchdog timer control/status register (WTCSR) of the watchdog timer to 0 to stop the watchdog timer.
    WDT.WTCSR = 0xA518;
    WDT.WTCNT = 0x5A00;
    WDT.WTCSR = 0xA51D;  // CKS[2:0] = b'101 : 1/1024 x P0 (7.8ms)

    CPG.STBCR1 = 0x80;
    dummy_8 = CPG.STBCR1;

    __WFI();

    core_util_critical_section_exit();
}

static void interrupt_button(void) {
#if(0)  // It may or may not be present.
    if (pTestTask != NULL) {
        pTestTask->signal_set(1);
    }
#endif
}

void test_task(void) {
    int test_cnt = 0;

    button.fall(&interrupt_button);
    button.rise(&interrupt_button);

    while (true) {
        SoftwareStandby();
#if(0)  // It may or may not be present.
        // It becomes sleep during idle task.
        Thread::signal_wait(1);
#endif
        led1 = !led1;
        printf("%d\r\n", test_cnt++);
        ThisThread::sleep_for(5);  // Wait for output completion of printf().
    }
}

int main() {
    Thread::attach_idle_hook(idle_hook);
    pTestTask = new Thread();
    pTestTask->start(test_task);
}
