#include "mbed.h"
#include "rtos.h"

InterruptIn button(USER_BUTTON0);
DigitalOut led1(LED1);
Thread * pTestTask = NULL;

static void idle_hook(void) {
    __WFI();  // Do not set when using SoftwareStandby.
}

static void interrupt_button(void) {
    if (pTestTask != NULL) {
        pTestTask->signal_set(1);
    }
}

void test_task(void) {
    int test_cnt = 0;

    button.fall(&interrupt_button);
    button.rise(&interrupt_button);

    while (true) {
        // It becomes sleep during idle task.
        Thread::signal_wait(1);
        led1 = !led1;
        printf("%d\n", test_cnt++);
    }
}

int main() {
    Thread::attach_idle_hook(idle_hook);
    pTestTask = new Thread();
    pTestTask->start(test_task);
}
