//------------------------------------------------------------------//
//Supported MCU:   RZ/A1H
//File Contents:   Motor Control using PwmOutResetSync.lib (GR-PEACH version on the Micon Car)
//Version number:  Ver.1.00
//Date:            2016.08.31
//Copyright:       Renesas Electronics Corporation
//------------------------------------------------------------------//

//This program supports the following boards:
//* GR-PEACH(E version)
//* Motor drive board Ver.5
//* Camera module (SC-310)

//Include
//------------------------------------------------------------------//
#include "mbed.h"
#include "PwmOutResetSync.h"

//Define
//------------------------------------------------------------------//
//Motor speed
#define     MAX_SPEED           85      /* motor()  set: 0 to 100   */

//Constructor
//------------------------------------------------------------------//
DigitalOut  Left_motor_signal(P4_6);
DigitalOut  Right_motor_signal(P4_7);
PwmOutResetSync pwm_l(P4_4);
PwmOutResetSync pwm_r(P4_5);

//Prototype
//------------------------------------------------------------------//
void motor( int accele_l, int accele_r );

//Main
//------------------------------------------------------------------//
int main( void )
{
    PwmOutResetSync::period_ms(1);   /* Other notation: "pwm_l.period_ms(1);" or "pwm_r.period_ms(1);" */

    while(1) {
        motor( 100, 0 );
        wait_ms( 1000 );
        motor( 0, 80 );
        wait_ms( 1000 );
        motor( -60, 0 );
        wait_ms( 1000 );
        motor( 0, -40 );
        wait_ms( 1000 );
        motor( 0, 0 );
        wait_ms( 1000 );
    }
}

//motor speed control(PWM)
//Arguments: motor:-100 to 100
//Here, 0 is stop, 100 is forward, -100 is reverse
//------------------------------------------------------------------//
void motor( int accele_l, int accele_r )
{
    accele_l = ( accele_l * MAX_SPEED ) / 100;
    accele_r = ( accele_r * MAX_SPEED ) / 100;

    /* Left Motor Control */
    if( accele_l >= 0 ) {
        /* forward */
        Left_motor_signal = 0;
        pwm_l.write((float)accele_l / 100);    /* Other notation: "pwm_l = (float)accele_l / 100;" */
    } else {
        /* reverse */
        Left_motor_signal = 1;
        pwm_l.write((float)(-accele_l) / 100); /* Other notation: "pwm_l = (float)(-accele_l) / 100;" */
    }

    /* Right Motor Control */
    if( accele_r >= 0 ) {
        /* forward */
        Right_motor_signal = 0;
        pwm_r.write((float)accele_r / 100);    /* Other notation: "pwm_r = (float)accele_r / 100;" */
    } else {
        /* reverse */
        Right_motor_signal = 1;
        pwm_r.write((float)(-accele_r) / 100); /* Other notation: "pwm_r = (float)(-accele_r) / 100;" */
    }
}

//------------------------------------------------------------------//
// End of file
//------------------------------------------------------------------//
