/* mbed Microcontroller Library
 * Copyright (C) 2016 Renesas Electronics Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "MotionEvent.h"

float MotionEvent::getX() {
    return (float)_s_touch[0].x;
}

float MotionEvent::getX(int pointerIndex) {
    return (float)_s_touch[pointerIndex].x;
}

float MotionEvent::getY() {
    return (float)_s_touch[0].y;
}

float MotionEvent::getY(int pointerIndex) {
    return (float)_s_touch[pointerIndex].y;
}

int MotionEvent::getPointerCount() {
    return _touch_idx;
}

int MotionEvent::getPointerId(int pointerIndex) {
    return _s_touch[pointerIndex].id;
}

int MotionEvent::getAction() {
    return _action;
}

int MotionEvent::getActionMasked() {
    return getAction() & ACTION_MASK;
}

long MotionEvent::getDownTime() {
    return _down_time;
}

long MotionEvent::getEventTime() {
    return _event_time;
}

int MotionEvent::findPointerIndex(int pointerId) {
    int ret = -1;
    for (int i = 0; i < TOUCH_NUM_MAX; i++) {
        if (_s_touch[i].id == pointerId) {
            ret = i;
            break;
        }
    }
    return ret;
}

void MotionEvent::debug_print() {
#if(1) //for debug
    int action = getAction();
    int index  = (action & MotionEvent::ACTION_POINTER_INDEX_MASK) >> MotionEvent::ACTION_POINTER_INDEX_SHIFT;
    int count  = getPointerCount();

    printf("action=%04x", action);
    printf(" index=%d", index);

    switch (getActionMasked()) {
        case ACTION_DOWN:          printf(" ACTION_DOWN        ");  break;
        case ACTION_UP:            printf(" ACTION_UP          ");  break;
        case ACTION_MOVE:          printf(" ACTION_MOVE        ");  break;
        case ACTION_CANCEL:        printf(" ACTION_CANCEL      ");  break;
        case ACTION_POINTER_DOWN:  printf(" ACTION_POINTER_DOWN");  break;
        case ACTION_POINTER_UP:    printf(" ACTION_POINTER_UP  ");  break;
    }
    printf(" DownTime=%8d, EventTime=%8d", getDownTime(), getEventTime());

    for (int i=0; i<count; i++) {
        printf("  id=%d,x=%5.1f,y=%5.1f", getPointerId(i), getX(i), getY(i));
    }
    printf("\n");
#endif
}


// MotionEventCtl

void MotionEventCtl::clearPointerCount() {
    _touch_idx = 0;
}

void MotionEventCtl::setPosData(int id, uint32_t x, uint32_t y) {
    if (_touch_idx < TOUCH_NUM_MAX) {
        _s_touch[_touch_idx].id = id;
        _s_touch[_touch_idx].x  = x;
        _s_touch[_touch_idx].y  = y;
        _touch_idx++;
    }
}

void MotionEventCtl::setActionInfo(int action, long time) {
    _action = action;
    _event_time   = time;
    if (action == ACTION_DOWN) {
        _down_time = time;
    }
}

