#include "mbed.h"
#include "ESP32Interface.h"
#include "TCPSocket.h"

ESP32Interface wifi(P5_3, P3_14, P7_1, P0_1);

int main() {
    printf("NetworkSocketAPI Example\r\n");

    wifi.connect("ssid", "password");
    printf("IP address: %s\r\n", wifi.get_ip_address());
    printf("MAC address: %s\r\n", wifi.get_mac_address());

    TCPSocket socket(&wifi);
    socket.connect("4.ifcfg.me", 23);

    char buffer[64];
    int count = socket.recv(buffer, sizeof(buffer));
    printf("public IP address is: %.15s\r\n", &buffer[15]);

    socket.close();
    wifi.disconnect();

    printf("Done\r\n");
}
