#include "mbed.h"
#include "SdUsbConnect.h"
#include "EasyPlayback.h"
#include "EasyDec_WavCnv2ch.h"

#define FNAME_LEN              (64)
#define MOUNT_NAME             "storage"

static InterruptIn skip_btn(USER_BUTTON0);
static EasyPlayback AudioPlayer;

static void skip_btn_fall(void) {
    AudioPlayer.skip();
}

int main() {
    DIR  * d;
    struct dirent * p;
    char file_path[sizeof("/"MOUNT_NAME"/") + FNAME_LEN];
    SdUsbConnect storage(MOUNT_NAME);

    AudioPlayer.add_decoder<EasyDec_WavCnv2ch>(".wav");  // decoder setting
    AudioPlayer.add_decoder<EasyDec_WavCnv2ch>(".WAV");  // decoder setting
    AudioPlayer.outputVolume(0.5);  // Volume control (min:0.0 max:1.0)
    skip_btn.fall(&skip_btn_fall);  // button setting

    while (1) {
        storage.wait_connect();
        d = opendir("/"MOUNT_NAME"/");  // file search
        while ((p = readdir(d)) != NULL) {
            size_t len = strlen(p->d_name);
            if (len < FNAME_LEN) {
                sprintf(file_path, "/%s/%s", MOUNT_NAME, p->d_name); // make file path
                printf("%s\r\n", file_path);
                AudioPlayer.play(file_path); // playback
            }
        }
        closedir(d);
    }
}
