/* mbed EasyPlaybackPWM Library
 * Copyright (C) 2017 dkato
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "EasyPlaybackPWM.h"

EasyPlaybackPWM::EasyPlaybackPWM(PinName pwm_l, PinName pwm_r) : audio(pwm_l, pwm_r), _skip(false), _pause(false)
{
    _audio_buf = new uint8_t[AUDIO_WRITE_BUFF_SIZE];
}

EasyPlaybackPWM::~EasyPlaybackPWM()
{
    delete [] _audio_buf;
}

bool EasyPlaybackPWM::get_tag(const char* filename, char* p_title, char* p_artist, char* p_album, uint16_t tag_size)
{
    FILE * fp;
    EasyDecoder * decoder;
    bool ret = false;

    decoder = create_decoer_class(filename);
    if (decoder == NULL) {
        return false;
    }

    fp = fopen(filename, "r");
    if (decoder->AnalyzeHeder(p_title, p_artist, p_album, tag_size, fp) != false) {
        ret = true;
    }
    delete decoder;
    fclose(fp);

    return ret;
}

bool EasyPlaybackPWM::play(const char* filename)
{
    size_t audio_data_size = AUDIO_WRITE_BUFF_SIZE;
    FILE * fp;
    EasyDecoder * decoder;
    bool ret = false;

    decoder = create_decoer_class(filename);
    if (decoder == NULL) {
        return false;
    }

     _skip = false;
    fp = fopen(filename, "r");
    if (decoder->AnalyzeHeder(NULL, NULL, NULL, 0, fp) == false) {
        // do nothing
    } else if  ((decoder->GetChannel() != 2)
            || (audio.format(decoder->GetBlockSize()) == false)
            || (audio.frequency(decoder->GetSamplingRate()) == false)) {
        // do nothing
    } else {
        while (audio_data_size == AUDIO_WRITE_BUFF_SIZE) {
            while ((_pause) && (!_skip)) {
                Thread::wait(100);
            }
            if (_skip) {
                break;
            }
            audio_data_size = decoder->GetNextData(_audio_buf, AUDIO_WRITE_BUFF_SIZE);
            if (audio_data_size > 0) {
                audio.write(_audio_buf, audio_data_size);
            }
        }
        Thread::wait(500);
        ret = true;
    }
    delete decoder;
    fclose(fp);

    return ret;
}

bool EasyPlaybackPWM::is_paused(void)
{
    return _pause;
}

void EasyPlaybackPWM::pause()
{
    _pause = !_pause;
}

void EasyPlaybackPWM::pause(bool type)
{
    _pause = type;
}

void EasyPlaybackPWM::skip(void)
{
    _skip = true;
}

bool EasyPlaybackPWM::outputVolume(float VolumeOut)
{
    return audio.outputVolume(VolumeOut);
}

EasyDecoder * EasyPlaybackPWM::create_decoer_class(const char* filename)
{
    std::map<std::string, EasyDecoder*(*)()>::iterator itr;
    char *extension = strstr((char*)filename, ".");

    if (extension == NULL) {
        return NULL;
    }

    itr = m_lpDecoders.find(extension);
    if (itr == m_lpDecoders.end()) {
        return NULL;
    }

    return (*itr).second();
}

