//***************** INCLUDES ***************************************************************
#include "mbed.h"
#include "string.h"
//***************** PROTOTYPES *************************************************************
void pc_isr();
void parse_pc(char*);

//***************** HARDWARE RECOURCES *****************************************************
DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

//***************** GLOBAL VARIABLES *******************************************************
#define RX_BUFFER_PC_SIZE 255
char rx_buffer_pc[RX_BUFFER_PC_SIZE] = {' '};
char stringcopy_isr_pc[RX_BUFFER_PC_SIZE] = {' '};
char stringcopy_pc[RX_BUFFER_PC_SIZE] = {' '};
int  rx_buffer_pc_poi = 0;
bool stringComplete_pc = false;  // whether the string is complete
char c;

//***************** THE MAIN PROGRAM ******************************************************* 
int main() {
//***************** INIT ******************************************************************* 
pc.baud(115200);
pc.printf("Hello world ! \r\n");
led1 = 0;
led1 = !led1;
wait(0.5);
led1 = !led1;
pc.attach(&pc_isr);
//**************** MAIN LOOP ***************************************************************    
while (1) {
   if (stringComplete_pc)                       //  set in interrupt
        {
        strncpy(stringcopy_pc, stringcopy_isr_pc, (unsigned)strlen(stringcopy_isr_pc));  
        parse_pc(stringcopy_pc);                                //  handle it and respond
        stringComplete_pc = false;                 // reset
        }  
    wait(0.5);
    led1 = !led1;
    }
}

//***************** PARSING PC COMMAND ******************************************************

void parse_pc(char* stringcopy)
{ 
char cmd;

if (stringcopy_pc[0] != '#')
  {
  pc.printf("@Syntax Error\r\n");
  return;
  } 
cmd = stringcopy_pc[1];  
switch(cmd)
  {
// Testing ....
    case 'v': pc.printf("Hello world ! v ! \r\n");
    break;            
    case 'a': pc.printf("Hello world ! a ! \r\n");
    break;
    }
 }


//***************** PC ISR *****************************************************************
void pc_isr() {
    if (pc.readable()) {
       do {
            c = pc.getc();
            rx_buffer_pc[rx_buffer_pc_poi] = c;
            rx_buffer_pc_poi++;
            if (c == '\n')
                {
                stringComplete_pc = true;
                strncpy(stringcopy_isr_pc, rx_buffer_pc, rx_buffer_pc_poi);
                rx_buffer_pc_poi=0;
                }
        }
        while (rx_buffer_pc_poi < RX_BUFFER_PC_SIZE && c != '\n');
    }
}
//***************** THE END **************************************************************** 