#ifndef MBED_BEEPER_H
#define MBED_BEEPER_H
 
#include "mbed.h"

namespace mbed {

/* Class: Beeper
 *  A class witch uses pwm to controle a beeper to generate sounds.
 */
class Beeper {

public:
    
    /* Constructor: Beeper
     *  Creates a new beeper object.
     * 
     * Variables:
     *  pin - The pin which is connected to the beeper.
     */
    Beeper (PinName pin);

    /* Function: beep
     *  Beep with given frequency and duration.
     *
     * Variables: 
     *  frequency - The frequency to use.
     *  time - The turation to beep.
     */
    void beep (float frequency, float time);

    /* Function: note
     *  Plays a midi note for a given time.
     *
     * Variables:
     *  note - The note to play.
     *  time - The duration to play the note.
     */
    void note (int, float time);
    void stop();        

  private :    
    PwmOut _pwm;
  };
}

#endif
