#include "mbed.h"
#include "avenidas.h"
 
// Definicion de parametros de comunicacion
 
Serial pc(USBTX,USBRX);
SPI deviceM(PB_5, PB_4, PB_3);  // D4(gris), Ninguno, D3(azul)
DigitalOut ssel (PA_4);         // A2(morado)
Ticker tp;
int printjugador =1;            // Establece el estado del jugador
 
// Definiendo Botones
 
AnalogIn vry(A3);               // Lee el eje x del jostick
AnalogIn vrx(A4);               // Lee el eje y del jostick
DigitalIn sw(A5);               // Lee el boton del jostick

// Definicion de Funciones       
void sendSPI();                 // Define el prototipo de la funcion de comunicacion con el MAX
void inicializar_matriz();      // Define el prototipo de Iniciar pantalla
void printstatus();             // Define el prototipo imprime el juego en pantalla
void desplazar_der();           // Define el prototipo que desplaza el jugador a la der 
void desplazar_izq();           // Define el prototipo que desplaza el jugador a la izq
void arriba();                  // Define el prototipo que desplaza el jugador hacia arriba
void pista();                   // Define el prototipo 
void puntaje();                 // Define el prototipo que cuenta el puntaje
void impresion();               // Define el prototipo 
void aumentar_dificultad();     // Define el prototipo  que aumenta la velocidad de los vehiculos
void reiniciar_calle();

// Definicion de Variables
 
uint16_t* nivel;
uint16_t* jugador;
uint16_t* victorias;
float velocidad = 1.0;
float meas_vx;
float meas_vy; 
uint8_t ubicacion;
uint8_t conteo = 2;

// Inicio del programa
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};
 
// La siguiente funcion establece los parametros de funcionamiento del MAX7219
 
void inicializar_matriz(){
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);    //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    
    int i;
    
    // Esta seccion configura el parpadeo cuando se reinicia la pantalla
    
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0F,0);
        wait (0.5);
    }
  
  }
 
// ------------------------------- Esta es la funcion principal del sistema 
int main() {
   pc.baud(38400);                 // Establece la velocidad de comunicacion Serial
   inicializar_matriz();           // llama a la funcion que configura el MAX
   nivel= AV_1;                    // Asigna el trasado de las calles al juego
   victorias=puntos;               // Asigna los puntos acumulados en la pantalla inicia en 0
   jugador=player;                 // Asigna la forma del jugador
   tp.attach(&printstatus,0.2);    // MIRAR para que sirve
   ubicacion=1;                    // Inicializa la varibale que cuenta la posicion del jugador
   

       
   while(1){
       
   meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X
   meas_vy = vry.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje Y
   
//------ realiza el corriemiento del vector hacia la izq y der respectivamente.

  if (meas_vx < 1600)           // si se cumple esta condicion el jugador se desplaza a la izq
      desplazar_izq(); 
  else if (meas_vx > 1700)      // si se cumple esta condicion el jugador se desplaza a la der
      desplazar_der();
 
//------ mueve a el jugador hacia arriba en el mapa
    
  if(meas_vy < 1550){   
     arriba();                  // hace el llamado a la funcion que mueve al jugador a la parte superior
     ubicacion++;               // cada vez que se ejecuta actualiza la posicion del jugador en el mapa
     pc.printf("\n ubicacion:\n %i",ubicacion);  // imprime la ubicacion del jugador en el puerto serial
     if(ubicacion==7)           // si la posicion del jugador es igual a 7 ejecuta la funcion puntaje();
        puntaje();         
     }
     
// ----- El siguiente ciclo realiza el desplazamiento de los vehiculos
  pista(); 
  
  wait(velocidad); // Velocidad del juego
               
       }
}

void desplazar_der(){               // Esta funcion desplaza al jugador hacia la derecha
      
      int der = jugador[7];    
      for(int i= 7; i>=0;i--){  
          jugador[i]=jugador[i-1];
          }
      jugador[0] = der;

    }

void desplazar_izq(){               // Esta funcion desplaza al jugador hacia la izq
   
      int izq = jugador[0];
      for(int i= 0; i<8;i++){  
          jugador[i]=jugador[i+1];
          }
      jugador[7] = izq;

 }
 
void arriba(){                      // Esta funcion desplaza al jugador hacia arriba
      
      int arb = 1;
      for(int i= 0; i<8;i++){  
          jugador[i]= jugador[i] << arb;
          }
      arb++;
      
    }
    
void pista(){                       // Esta funcion ejecuta el movimiento de los vehiculos
    
    int aux = nivel[0];
      for(int i= 0; i<8;i++){  
          nivel[i]=nivel[i+1];
          }
      nivel[7] = aux;
    
    }  
    
void puntaje(){                     // Esta funcion hace el conteo de los puntos ganados
      
      victorias[conteo]=0x80;       // cada vez que se llega al otro lado de la calle suma 1 punto que se visualiza en pantalla
      for(int i= 0; i<8;i++){       // Este ciclo for regresa al jugador a la pos 1
          jugador[i]= jugador[i] >> 6;  
          }
      ubicacion=1;                  // Renicializa la pos del jugador
      conteo++;                     // Cuenta cuantas veces a llegado el jugador al otro lado  hasta un maximo de 4
      if(conteo == 6){              // cuando el conteo es igual a 6 se llama a la funcion aumentar dificultad
         aumentar_dificultad();
         }
         
    
      } 

void aumentar_dificultad(){          // Esta funcion aumenta la dificultad del juego       
      
      for(int i= 0; i<8;i++){        // Regresa el valor de las victorias acumuladas a 0
          victorias[i]= 0;
          }
      velocidad = velocidad - 0.1;   // aumenta la velocidad del juego
      conteo=2;                      // reinicializa el conteo
       
      
      }
void reiniciar_calle(){             // Esta condicion renicia el sistema al estrellarce con un vehiculo
    
    NVIC_SystemReset();
    
    }    
void printstatus()                  // Esta funcion es la encargada de la impresion
{
    
    for(int j= 1; j<=8;j++)         // Este cilo imprime en pantalla
        if (printjugador){
            sendSPI(j, nivel[j-1]|jugador[j-1]| victorias[j-1]);   // CADA VEZ que se vea en pantalla SPI se mostrar un dato en pantalla
            if((nivel[j-1] & jugador[j-1]) != 0){                  // SI este if se cumple el jugador ha sido chocado
               reiniciar_calle();                                  // Ee se hace llamado a la funcion reinicio
               }
               
            }else{
                sendSPI(j, nivel[j-1]| victorias[j-1]);            
                }
             
    printjugador =!printjugador;
}