#include "mbed.h"
#include "vehiculos.h"

// Definicion de parametros de comunicacion

Serial pc(USBTX,USBRX);
SPI deviceM(PB_5, PB_4, PB_3);  //D4(gris), Ninguno, D3(azul)
DigitalOut ssel (PA_4);         //A2(morado)
Ticker tp;
InterruptIn pulsador_abj(D8);               // Lee el boton del jostick

int printjugador =1;

// Definiendo Botones

AnalogIn vry(A3);
AnalogIn vrx(A4);
DigitalIn sw(A5);

// Definicion de Funciones

void sendSPI();
void inicializar_matriz();
void desplazar_izq();
void desplazar_der();
void selec_nivel();
void desplazar();
void selec();
void juego();
void printstatus();


// Definicion de Variables

uint16_t* nivel;
uint16_t* fail;
uint16_t* jugador;
uint16_t* camino;
uint8_t  enable_abj=1;
uint8_t  enable_der=1;
uint8_t  enable_izq=1;
uint8_t  figura;
uint8_t  pos;
uint8_t  giro;
uint8_t  posicion_fig=3;
float velocidad = 0.4;


void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};


void inicializar_matriz(){
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);    //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0F,0);
        wait (0.5);
    }
  
  }

int main() {
    
    pc.baud(38400);
    inicializar_matriz();
    
    while(1){

        selec();

        }

    }
    

 
 void selec(){
   
   figura=rand()%4;
   
   switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // carro derecha
             nivel = CR_DER;
             break;
             case 1: // carro izquierda       
             nivel = CR_IZQ;
             break;
             case 2: // caja derecha
             nivel = CJ_DER;
             break;
             case 3: // caja izquierda
             nivel = CJ_IZQ;
             break;
             }
       
       juego();
       
   }  
 
 void  aum_velocidad_tx(){
     velocidad=0.2;
     }  
 
 void juego(){
 
   jugador=MICARRO;
   camino= CALLE;
   fail=EQUIS;
   //tp.attach(&printstatus,0.2);
   enable_abj=1;
   enable_der=1;
   enable_izq=1;
   // Declaracion de Variables de lectura del jostick
   float meas_vx;
   int i=0;
 
while(enable_abj){

    int j=1;  // inicia el contador j en 1 
     
    while(j<=8){ //se encarga de seleccionar que posicion del vector imprimira
         
         sendSPI(j, jugador[j-1]|(nivel[j-1]>>i)|camino[j-1]);  //Imprime el resultado de aplicar OR a la memoria y al desplamamiento de imprimir
         //wait(0.1); // Activar este wait para pruebas de desplazamiento y captura de los datos
 
     if(i==13){  //Detiene el desplazamiento cuando los bits tocan fondo, 
         enable_abj=0;// desabilitador del ciclo while 
         }  
     if((jugador[j-1]&(nivel[j-1]>>i))!=0){
         
         NVIC_SystemReset();
         
         }  
     j++;
     } 
     wait(velocidad); // espera para tomar el otro valor de lectura
     // ----------------------Lectura del jostick-----------------------------
     
     // Lectura de parametros del jostick
     meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X

    if (meas_vx < 1600 && enable_izq)
           desplazar_izq(); 
    else if (meas_vx > 1700 && enable_der)
           desplazar_der();
     i++;
     pulsador_abj.fall(&aum_velocidad_tx);
     }
}
     
void desplazar_izq(){
      
      enable_der=1;
      posicion_fig--;
      
      
      if(posicion_fig==2)
         enable_izq=0;
      
      
      int izq = jugador[0];
      for(int i= 0; i<8;i++){  
          jugador[i]=jugador[i+1];
          }
      jugador[7] = izq; 
    
}

void desplazar_der(){
      
      enable_izq=1;
      posicion_fig++;
      
      if(posicion_fig==5)
         enable_der=0;
          
      int der = jugador[7];
      for(int i= 7; i>=0;i--){  
          jugador[i]=jugador[i-1];
          }
      jugador[0] = der;
      
    }


void printstatus()
{
 
    for(int j= 1; j<=8;j++)
        if (printjugador)
            sendSPI(j, nivel[j-1]|jugador[j-1]|camino[j-1]);     
        else
            sendSPI(j, nivel[j-1]|camino[j-1]);         
    printjugador =!printjugador;
    
    for ( int i=1;i<13;i++){
         for( int l=0;l<8;l++){
             nivel[l]=nivel[l]<<i;
             
             }
        }
    
}        