#include "mbed.h"
#include "piezas.h"
//#define DEBUG 1


Serial pc(USBTX,USBRX);    
SPI deviceM(PB_15, PB_14, PB_13);  //SE DEFINE EL LED QUE ACTIVARA  EL DISPOSITIVO
DigitalOut ssel (PB_12);
DigitalIn pulsador_izq(A5); //pulsador conector izquierdo
DigitalIn pulsador_der(A4); //pulsador conector derecho
DigitalIn p_giro(A3); //pulsador conector giro

//Declaracion de funciones
void inicializar();
void pulsador_der();

uint16_t* girar(uint16_t* pieza, int posicion);
int memoria[8]={0};
int *pointer=0;
void debuging(char*s,...){
    
    #if DEBUG
    pc.printf(s);
    #endif
    
    }

// FUNCION EL CUAL ENVIA EL DATO JUNTO CON LA DIRECCION DE LA COLUMNA CORRESPONDIENTE AL PRIMER  DISPOSITIVO
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;            // SELECCIONA EL PRIMER DISPOSOTIVO
    deviceM.write(d1); // ESCRIBE EL ADDRESS
    deviceM.write(d2); // ESCRIBE EL DATA
    ssel=1;
    deviceM.lock();
};

// Toma el vector reorganizado , lo imprime y lo almacena
void captura_matriz(uint16_t* imprimir,int posicion,int auxi, char figura, char giro, int izq, int der){
int i=0; // inicia el contador i en 0
int enable=1;

 while(enable){ //se encarga de desplazar los bits dentro del vector
    //pc.printf("\n1- conteo del corriemiento:\n %d",i);

    int j=1;  // inicia el contador j en 1        
           
           while(pulsador_izq ==1 & pulsador_der==0 & p_giro == 0 && posicion<izq){
            //pc.printf("\n >>>>>>>>>>>>FERNEY PRUEBA1 giro  %d, posicion %d, izq %d, der %d\n ",giro, posicion,izq,der);
            posicion++;
            for(int ci=7; ci >=0; ci--){
                pc.printf("\n hacia la izq:\n ");
            //pc.printf("\n >>>>>>>>>>>>FERNEY PRUEBA1 IZQ giro  %d, posicion %d\n ",giro, posicion);
                imprimir[ci]=imprimir[ci-1];
                if(ci==0){
                    imprimir[ci]=0;
                    
                    }         
                }
            for(int m=1;m<=8;m++){
                 sendSPI(m, memoria[m-1]|(imprimir[m-1]>>i-1));
                 }   
            wait(1.0);  
 
            }
            
            while(pulsador_der ==1 & pulsador_izq ==0 & p_giro == 0 && posicion>der){
            //pc.printf("\n hacia la der:\n ");
            //pc.printf("\n >>>>>>>>>>>>FERNEY PRUEBA1 DER giro  %d, posicion %d, izq %d, der %d\n ",giro, posicion,izq,der);
            posicion--;
            for(int k=0; k <8; k++){
 
                imprimir[k]=imprimir[k+1];
                if(k==7){
                    imprimir[k]=0;
                    
                    }
                }    
            for(int n=1;n<=8;n++){
                 sendSPI(n, memoria[n-1]|(imprimir[n-1]>>i-1));
                 }   
            wait(1.0); 
                
            }  
   if(p_giro == 1 & pulsador_der ==0 & pulsador_izq ==0){
           giro++;
           //pc.printf("\n >>>>>>>>>>>>FERNEY PRUEBA GIRO giro  %d, posicion %d, izq %d, der %d\n ",giro, posicion,izq,der);
           if(giro ==4){
               giro=0;
               }
           switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // L
             if(giro == 0)
             imprimir= girar(PZA_L, posicion);
             izq=6, der = 0;
             auxi=7;          
             if(giro == 1)
             imprimir= girar(PZA_LDN, posicion);
             izq=5, der = 0;
             auxi=7;
             if(giro == 2)
             imprimir= girar(PZA_LDO, posicion);
             izq=5, der = -1;
             auxi=7;
             if(giro == 3)
             imprimir=girar(PZA_LDD, posicion);
             izq=5, der = 0;
             auxi=8;
             break;
             case 1://T       
             if(giro == 0)
             imprimir= girar(PZA_T, posicion);
             izq=5, der = 0;
             auxi=9;
             if(giro == 1)
             imprimir= girar(PZA_TN, posicion);
             izq=6, der = 0;
             auxi=8;
             if(giro == 2)
             imprimir= girar(PZA_TO, posicion);
             izq=5, der = 0;
             auxi=8;
             if(giro == 3)
             imprimir= girar(PZA_TD, posicion);
             izq=5, der = -1;
             auxi=8;
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_I, posicion);
             izq=6, der = -1;
             auxi=8;
             if(giro == 1 || giro == 3)
             imprimir=girar(PZA_IR, posicion);
             izq=5, der = 0;
             auxi=9;
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             imprimir= girar(PZA_C, posicion);
             izq=6, der = 0;
             auxi=9;
             break;   
             case 4: //Z
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_Z, posicion);
             izq=5, der = 0;
             auxi=9;
             if(giro == 1 || giro == 3)
             imprimir= girar(PZA_ZN, posicion);
             izq=6, der = 0;
             auxi=8;
             break;

             }  
             
             
             
             }             
             
    while(j<=8){ //se encarga de seleccionar que posicion del vector imprimira
         
         sendSPI(j, memoria[j-1]|(imprimir[j-1]>>i));  //Imprime el resultado de aplicar OR a la memoria y al desplamamiento de imprimir
         //wait(0.1); // Activar este wait para pruebas de desplazamiento y captura de los datos

     if(i==auxi-1 || (memoria[j-1]&(imprimir[j-1]>>i+1))!=0){  //Detiene el desplazamiento cuando los bits tocan fondo, 
         enable=0;// desabilitador del ciclo while 
         
         for(int k=0; k<8;k++){                          // Almacena todos lo datos del vector en la posicion que corrimiento en la memoria
              memoria[k]= memoria[k]|(imprimir[k]>>i);
             pointer= &memoria[k];
             pc.printf("\n pointer %d \n", *pointer);
             if(*pointer==511){
                 NVIC_SystemReset();
                 }
             
             }
    
         }
     j++;
     } 
     wait(1.0); // espera para tomar el otro valor de lectura
     i++;
     }

  }

 void desplazar(uint16_t* datos, int posicion, int auxi, char figura, char giro, int izq, int der){ // tomar la figura y la desplaza segun la posicion ingresada inicialmente
    
  uint16_t desplazamiento[8]={0};      // Inicia un vector auxiliar con solo Ceros
  int j= 0;
  
       for(int i=posicion; i<(posicion+3);i++){  // Inicia un vector auxiliar con solo Ceros
           desplazamiento[i]=datos[j]; // Alamcena los nuevos datos tomados en el vector 
           j++;                    
                          }
       captura_matriz(desplazamiento,posicion,auxi,figura,giro,izq,der); //Envia el Vector desplazado la funcion de captura de matriz
  }
  
 void read(int posicion, char figura, char giro){
      
         switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // L
             if(giro == 0)
             desplazar(PZA_L,posicion,8,figura,giro,6,0);
             if(giro == 1)
             desplazar(PZA_LDN,posicion,8,figura,giro,5,0);
             if(giro == 2)
             desplazar(PZA_LDO,posicion,8,figura,giro,5,-1);
             if(giro == 3)
             desplazar(PZA_LDD,posicion,9,figura,giro,5,0);
             break;
             case 1://T       
             if(giro == 0)
             desplazar(PZA_T,posicion,9,figura,giro,5,0);
             if(giro == 1)
             desplazar(PZA_TN,posicion,8,figura,giro,6,0);
             if(giro == 2)
             desplazar(PZA_TO,posicion,8,figura,giro,5,0);
             if(giro == 3)
             desplazar(PZA_TD,posicion,8,figura,giro,5,-1);
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             desplazar(PZA_I,posicion,8,figura,giro,6,-1);
             if(giro == 1 || giro == 3)
             desplazar(PZA_IR,posicion,9,figura,giro,5,0);
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             desplazar(PZA_C,posicion,9,figura,giro,6,0);
             break;   
             case 4: //Z
             if(giro == 0 || giro == 2)
             desplazar(PZA_Z,posicion,9,figura,giro,5,0);
             if(giro == 1 || giro == 3)
             desplazar(PZA_ZN,posicion,8,figura,giro,6,0);
             break;
             default:
             figura=0;
             giro=0;
             desplazar(VACIO,posicion,9,figura,giro,6,0);
             break;
             }
     }

void captura_datos(){
         
         pc.baud(38400); //Inicializa la velocidad de comunicacion
         char inicio=0;
         int posicion= 0;
         char figura= 0;
         char giro= 0;
         char final=0;
         
         debuging("\n Ingrese el inicio del comando. ");
         inicio=pc.getc(); 
         debuging("\n Ingrese la Figura. ");
         figura=pc.getc();
         debuging("\n Seleccione el giro. ");
         giro=pc.getc();
         debuging("\n Seleccione la posicion. ");
         posicion=pc.getc(); 
         debuging("\n Ingrese el final del comando. ");
         final=pc.getc();    
         
         if(inicio!= '<' || final != '>'){
             
             debuging("\n Error en el comando.");
             
             }else{
                 
                 read(posicion,figura,giro);
                  
                 }
                 
         

    }
    
void inicializar(){ //INICIALIZA LA MATRIZ 
    
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);   
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0f,0);
        wait (0.5);
    }
    
    for (int j= 1; j<=8;j++){  // limpia la pantalla al encenderce o reiniarcea asi 
                               //no quedan leds encendidos cuando se ejecute el programa nuevamente
          
          sendSPI(j, 0x00);    //pone cada columna y vecto en blanco al inicializar
                            } 
    }

 
int main() {
    inicializar(); // Inicializa el programa para establecer los modos de trabajo liminosidad
    while(1){
            captura_datos(); // Inicia la lectura de la informacion
            }
 
}

uint16_t* girar(uint16_t* pieza, int posicion){
     uint16_t desplazamiento[8]={0};                      
     int l= 0;
     for(int o=posicion; o<(posicion+3);o++){  // Inicia un vector auxiliar con solo Ceros
     desplazamiento[o]=pieza[l]; // Alamcena los nuevos datos tomados en el vector 
     l++;                    
     }
    
    return desplazamiento;
    }