#include "mbed.h"
#include "piezas.h"
//#define DEBUG 1
 
//Establecimiento de la comunicacion
Serial pc(USBTX,USBRX);  
SPI deviceM(PB_5, PB_4, PB_3);  // D4(gris), Ninguno, D3(azul)
//SPI deviceM(PB_15, PB_14, PB_13);  
DigitalOut ssel (PA_4);         // A2(morado)
//DigitalOut ssel (PB_12);

//Delcaracion de botones

// InterruptIn pulsador_izq(A5);
// InterruptIn pulsador_der(A4);
// DigitalIn p_giro(A3);
// DigitalIn obligar_bajar(A0);

// Definiendo Botones
 
AnalogIn vry(A3);               // Lee el eje x del jostick
AnalogIn vrx(A4);               // Lee el eje y del jostick
InterruptIn pulsador_abj(D8);               // Lee el boton del jostick

//Declaracion de funciones
void inicializar();
void sendSPI(uint8_t d1, uint8_t d2);
void captura_datos();
void read();
void desplazar();
void captura_matriz();
void desplazar_izq();
void desplazar_der();
void aum_velocidad();
void perder();
uint16_t* girar(uint16_t* pieza, int posicion);
// Declaracion de variables 
int8_t posicion= 0, figura= 0, giro= 0;
uint16_t memoria[8]={0};
uint16_t* imprimir;
uint16_t *borde=0;
int8_t corrimiento=0;
float meas_vx;
float meas_vy;
float velocidad=1.0;
// Delcaraion de limites
int8_t liminf=0, limizq=0, limder=0;
// Habilitadores
int enableizq=1;
int enableder=1;
int bajando=1;
 
void debuging(char*s,...){
    
    #if DEBUG
    pc.printf(s);
    #endif
    
    }
 
// FUNCION EL CUAL ENVIA EL DATO JUNTO CON LA DIRECCION DE LA COLUMNA CORRESPONDIENTE AL PRIMER  DISPOSITIVO
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;            // SELECCIONA EL PRIMER DISPOSOTIVO
    deviceM.write(d1); // ESCRIBE EL ADDRESS
    deviceM.write(d2); // ESCRIBE EL DATA
    ssel=1;
    deviceM.lock();
};
 
 
int main() {
    inicializar(); // Inicializa el programa para establecer los modos de trabajo liminosidad
    while(1){
            captura_datos(); // Inicia la lectura de la informacion
            perder();
            }
}
 
void captura_datos(){
         
         pc.baud(38400); //Inicializa la velocidad de comunicacion
         //-----------------------------------------
         char inicio=0,final=0;
         figura=0;
         giro=0;
         posicion=0;
         
         debuging("\n Ingrese el inicio del comando. ");
         inicio=pc.getc(); 
         debuging("\n Ingrese la Figura. ");
         figura=pc.getc();
         debuging("\n Seleccione el giro. ");
         giro=pc.getc();
         debuging("\n Seleccione la posicion. ");
         posicion=pc.getc(); 
         debuging("\n Ingrese el final del comando. ");
         final=pc.getc();   
         
        
          if(inicio!= '<' || final != '>'){
             
             debuging("\n Error en el comando.");
             
             }else{
                 
                 read();
                  
                 }
          //------------------------------------------------------
          
         /*//--------------------figuras con random------------------
          figura=0;
          giro=0;
          figura=rand()%5;
          giro=rand()%5;
          posicion=rand()%6;;
          read();
         *///--------------------------------------------------------
        
                 
         
 
    }
    
void inicializar(){ //INICIALIZA LA MATRIZ 
    
    sendSPI(0x0c,1);    
    sendSPI(0x0b,7);
    sendSPI(0x09,0);   
    sendSPI(0x0A,0x00); //SELECCIONA LA LUMINOSIDAD DE LA MATRIZ
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0f,0);
        wait (0.5);
    }
    
    for (int j= 1; j<=8;j++){  // limpia la pantalla al encenderce o reiniarcea asi 
                               //no quedan leds encendidos cuando se ejecute el programa nuevamente
          
          sendSPI(j, 0x00);    //pone cada columna y vecto en blanco al inicializar
                            } 
    }
    
 void read(){
         
         switch(figura){ //Este switch escoje la figura con que trabajaar
             case 0: // L
             if(giro == 0)
             imprimir =  PZA_L,liminf=7, limizq=6, limder=0;
             if(giro == 1)
             imprimir =  PZA_LDN,liminf=7, limizq=5, limder=0;
             if(giro == 2)
             imprimir =  PZA_LDO,liminf=7, limizq=5, limder=-1;
             if(giro == 3)
             imprimir =  PZA_LDD,liminf=8, limizq=5, limder=0;
             break;
             case 1://T       
             if(giro == 0)
             imprimir =  PZA_T,liminf=8, limizq=5, limder=0;
             if(giro == 1)
             imprimir =  PZA_TN,liminf=7, limizq=6, limder=0;
             if(giro == 2)
             imprimir =  PZA_TO,liminf=7, limizq=5, limder=0;
             if(giro == 3)
             imprimir =  PZA_TD,liminf=7, limizq=5, limder=-1;
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             imprimir =  PZA_I,liminf=7, limizq=6, limder=-1;
             if(giro == 1 || giro == 3)
             imprimir =  PZA_IR,liminf=8, limizq=5, limder=0;
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             imprimir =  PZA_C,liminf=8, limizq=6, limder=0;
             break;
             case 4:
             if(giro == 0 || giro == 2)
             imprimir =  PZA_Z,liminf=8, limizq=5, limder=0;
             if(giro == 1 || giro == 3)
             imprimir =  PZA_ZN,liminf=7, limizq=6, limder=0;
             break;
             default:
             imprimir = VACIO;
             break;
             }
            // pc.printf("\n limite inferior read %d\n ",liminf);
             desplazar();
     }    
  void desplazar(){
      
      uint16_t desplazamiento[8]={0};      // Inicia un vector auxiliar con solo Ceros
      int j= 0;
       for(int i=posicion; i<(posicion+3);i++){  // Inicia un vector auxiliar con solo Ceros
           desplazamiento[i]=imprimir[j]; // Alamcena los nuevos datos tomados en el vector 
           j++;                    
                          }
       imprimir=desplazamiento;
       captura_matriz();
      }  
      
void captura_matriz(){
    
int i=0; // inicia el contador i en 0
int enable=1;
enableizq=1;
enableder=1;
bajando=1;
velocidad=1.0;
 while(enable){ //se encarga de desplazar los bits dentro del vector
    //pc.printf("\n1- conteo del corriemiento:\n %d",i);
    corrimiento=i;
    int j=1;  // inicia el contador j en 1 
     
    while(j<=8){ //se encarga de seleccionar que posicion del vector imprimira
         
         sendSPI(j, memoria[j-1]|(imprimir[j-1]>>i));  //Imprime el resultado de aplicar OR a la memoria y al desplamamiento de imprimir
         //wait(0.1); // Activar este wait para pruebas de desplazamiento y captura de los datos
 
     if(i==liminf || (memoria[j-1]&(imprimir[j-1]>>i+1))!=0){  //Detiene el desplazamiento cuando los bits tocan fondo, 
         enable=0;// desabilitador del ciclo while 
         bajando=0;
         for(int k=0; k<8;k++){                          // Almacena todos lo datos del vector en la posicion que corrimiento en la memoria
              memoria[k]= memoria[k]|(imprimir[k]>>i);
             }
    
         }
     j++;
     } 
     wait(velocidad); // espera para tomar el otro valor de lectura
     // ----------------------Lectura del jostick-----------------------------
     
     meas_vx = vrx.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje X
     meas_vy = vry.read() * 3300; // Convierte el valor de lectura de la entrada entre 0-3300 eje Y
     
     //------ realiza el corriemiento del vector hacia la izq y der respectivamente.
  
 
  if (meas_vx > 1700 && (posicion < limizq))           // si se cumple esta condicion el jugador se desplaza a la izq
      desplazar_izq(),i--; 
  else if (meas_vx < 1600 && (posicion > limder))      // si se cumple esta condicion el jugador se desplaza a la der
      desplazar_der();
      

     //-----------------------Giro de la pieza--------------------------------
     
     if(meas_vy > 1700 || meas_vy < 1600){
           giro++;       
           if(giro ==4){
               giro=0;
               }
           switch(figura){
             case 0: // L
             if(giro == 0)
             imprimir= girar(PZA_L, posicion),liminf=7, limizq=6, limder=0,i--;
             if(giro == 1)
             imprimir= girar(PZA_LDN, posicion),liminf=7, limizq=5, limder=0,i--;
             if(giro == 2)
             imprimir= girar(PZA_LDO, posicion),liminf=7, limizq=5, limder=-1,i--;
             if(giro == 3)
             imprimir=girar(PZA_LDD, posicion),liminf=8, limizq=5, limder=0,i--;
             break;
             case 1://T       
             if(giro == 0)
             imprimir= girar(PZA_T, posicion),liminf=8, limizq=5, limder=0,i--;
             if(giro == 1)
             imprimir= girar(PZA_TN, posicion),liminf=7, limizq=6, limder=0,i--;
             if(giro == 2)
             imprimir= girar(PZA_TO, posicion),liminf=7, limizq=5, limder=0,i--;
             if(giro == 3)
             imprimir= girar(PZA_TD, posicion),liminf=7, limizq=5, limder=-1,i--;
             break;
             case 2://I
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_I, posicion),liminf=7, limizq=6, limder=-1,i--;
             if(giro == 1 || giro == 3)
             imprimir=girar(PZA_IR, posicion),liminf=8, limizq=5, limder=0,i--;
             break;
             case 3://Cuadrado
             if(giro == 0 || giro == 1 || giro == 2 || giro == 3)
             imprimir= girar(PZA_C, posicion),liminf=8, limizq=6, limder=0,i--;
             break;   
             case 4: //Z
             if(giro == 0 || giro == 2)
             imprimir= girar(PZA_Z, posicion),liminf=8, limizq=5, limder=0,i--;
             if(giro == 1 || giro == 3)
             imprimir= girar(PZA_ZN, posicion),liminf=7, limizq=6, limder=0,i--;
             break;
 
             }

             }
     
     //---------------------------------------------------------------
     pulsador_abj.fall(&aum_velocidad);

     i++;
     }
 
  }
  
  void desplazar_izq(){
     
      if(posicion<limizq & corrimiento<liminf & enableizq){
          posicion++;
          
            for(int i=7; i >=0; i--){
                imprimir[i]=imprimir[i-1];
                if(i==0){
                    imprimir[i]=0;
                    
                    } 
                if((memoria[i+1] & (imprimir[i]>>corrimiento))!=0){
                    enableizq=0;
                    }      
                            
                }
            for(int j=1;j<=8;j++){
             sendSPI(j, memoria[j-1]|(imprimir[j-1]>>corrimiento));
 
                 }   
            wait(1.0);  
          
          }
      return;
      }
      
  void desplazar_der(){
      if(posicion>limder & corrimiento<liminf & enableder & bajando){
           posicion--;
           
            for(int i=0; i <8; i++){
                int der =(memoria[i+1] & (imprimir[i]>>corrimiento));
                imprimir[i]=imprimir[i+1];
                if(i==7){
                    imprimir[i]=0;
                    
                    }
                if((memoria[i-1] & (imprimir[i]>>corrimiento))!=0){
                    enableder=0;
                    pc.printf("\n multisder en :%d\n ",der);
                    pc.printf("\n derecho:%d\n ",enableder);
                    }     
                }    
            for(int j=1;j<=8;j++){
                 sendSPI(j, memoria[j-1]|(imprimir[j-1]>>corrimiento));
                 }   
            wait(1.0); 
      }
      return;
     
  } 
      
  uint16_t* girar(uint16_t* pieza, int posicion){
     uint16_t desplazamiento[8]={0};                      
     int j= 0;
     for(int i=posicion; i<(posicion+3);i++){  // Inicia un vector auxiliar con solo Ceros
     desplazamiento[i]=pieza[j]; // Alamcena los nuevos datos tomados en el vector 
     j++;                    
     }
    
    return desplazamiento;
    }
    
 void perder(){
     for(int i=0; i<8;i++){                          // Almacena todos lo datos del vector en la posicion que corrimiento en la memoria
        borde= &memoria[i];
        if(*borde>255){
          NVIC_SystemReset();
          }
        }
    }  
    
 void  aum_velocidad(){
     velocidad=0.2;
     }  