#include "mbed.h"
#include "piezas.h"

Serial pc(USBTX,USBRX);
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};
 
void inicializar_matriz(){
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0f);
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0f,0);
        wait (0.5);
    }
  
  }
  
    
void captura_matriz(uint16_t* imprimir){
 
 for(int i=0; i<11; i++){   // realiza el desplazamiento de los bits
     for (int j= 1; j<=8;j++){  // seleciona la columna a imprimir empezando desde la 1
          sendSPI(j, imprimir[j-1]>>i);
                            }    
     wait(1.5);
                         }
  
  }
 
 void desplazar(uint16_t* datos, char des){
    
  uint16_t desplazamiento[8]={0};
  int j= 0;
  
       for(int i=des; i<(des+3);i++){
           desplazamiento[i]=datos[j];
           j++;                    
                          }
       captura_matriz(desplazamiento);
       captura_matriz(TEST);
       des=0;
       j=0;
  }
  
  
  void read_in(){
         
         pc.baud(38400);
         
         char pos=0;
         char figura= 0;
         char giro= 0;
         
         pos=pc.getc();
       
         figura=pc.getc();
         
         giro=pc.getc();
      
      switch(figura){
             case 0:
                   switch(giro){
                       case 0:
                       desplazar(PZA_LD, pos);
                      
                             break;
                       case 1:
                       desplazar(PZA_LDN, pos);
                
                             break;
                       case 2:
                       desplazar(PZA_LDO, pos);
                       
                             break;
                       case 3:
                       desplazar(PZA_LDD, pos);
                       
                             break;
                       default:
                       captura_matriz(VACIO);
                       
                             break;             
                       }
                   break;
             case 1:
                   switch(giro){
                       case 0:
                       desplazar(PZA_T,pos);
                       
                             break;
                       case 1:
                       desplazar(PZA_TN,pos);
                       
                             break;
                       case 2:
                       desplazar(PZA_TO,pos);
                       
                             break;
                       case 3:
                       desplazar(PZA_TD,pos);
                       
                             break;
                       default:
                       captura_matriz(VACIO);
                       
                             break;             
                       }
                   break;      
             case 2:
                   switch(giro){
                       case 0: case 2:
                       desplazar(PZA_I,pos);
                             break;
                       case 1: case 3:
                       desplazar(PZA_IR, pos);
                             break;
                       default:
                       captura_matriz(VACIO);
                             break;             
                       }
                   break;
             case 3:
                   switch(giro){
                       case 0: case 1: case 2: case 3:
                       desplazar(PZA_C,pos);
                             break;
                       default:
                       captura_matriz(VACIO);
                             break;             
                       }
                   break;
             case 4:
                   switch(giro){
                       case 0:
                       desplazar(PZA_Z,pos);
                             break;
                       case 1:
                       desplazar(PZA_ZN,pos);
                             break;
                       case 2:
                       desplazar(PZA_ZO,pos);
                             break;
                       case 3:
                       desplazar(PZA_ZD,pos);
                             break;
                       default:
                       captura_matriz(VACIO);
                             break;             
                       }
                   break;      
             default:
             captura_matriz(VACIO);
                    break; 

             }
             captura_matriz(VACIO);
                      
      }

  
int main() {
                   
   inicializar_matriz();
   
   while(1){
         
         read_in();
                      
   }
    
}